/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class StringExtractor {
    private String annotation;
    private String[] strs;
    private int last;
    private Pattern ignorePattern;
    private char ignore;
    private StringBuffer current;
    public static char USUALLY = (char)35;
    public static char FASTA = (char)62;

    private StringExtractor(int initSize, char ignore) throws IllegalArgumentException {
        if (initSize < 1) {
            throw new IllegalArgumentException("The initSize is too small.");
        }
        this.last = 0;
        this.strs = new String[initSize];
        this.ignore = ignore;
        this.ignorePattern = Pattern.compile("^\\s*" + ignore + ".*");
    }

    public StringExtractor(File file, int initSize) throws IOException, FileNotFoundException {
        this(file, initSize, USUALLY);
    }

    public StringExtractor(File file, int initSize, char ignore) throws IOException, FileNotFoundException {
        this(initSize, ignore);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String str = null;
        while ((str = reader.readLine()) != null) {
            this.insert(str);
        }
        if (this.current != null && this.current.length() > 0) {
            this.strs[this.last++] = this.current.toString();
            this.current.delete(0, this.current.length());
        }
        reader.close();
        this.annotation = file.getName();
    }

    public StringExtractor(File file, int initSize, String annotation) throws IOException, FileNotFoundException {
        this(file, initSize);
        this.annotation = annotation;
    }

    public StringExtractor(File file, int initSize, char ignore, String annotation) throws IOException, FileNotFoundException {
        this(file, initSize, ignore);
        this.annotation = annotation;
    }

    public StringExtractor(String content, int initSize, String annotation) {
        this(content, initSize, USUALLY, annotation);
    }

    public StringExtractor(String content, int initSize, char ignore, String annotation) {
        this(initSize, ignore);
        StringTokenizer tok = new StringTokenizer(content, "\n");
        while (tok.hasMoreTokens()) {
            this.insert(tok.nextToken());
        }
        if (this.current != null && this.current.length() > 0) {
            this.strs[this.last++] = this.current.toString();
            this.current.delete(0, this.current.length());
        }
        this.annotation = annotation;
    }

    private void expand() {
        String[] temp = new String[2 * this.strs.length];
        System.arraycopy(this.strs, 0, temp, 0, this.strs.length);
        this.strs = temp;
        temp = null;
    }

    public String getString(int i) {
        if (i >= this.last) {
            throw new IndexOutOfBoundsException();
        }
        return this.strs[i];
    }

    public int getNumberOfStrings() {
        return this.last;
    }

    private void insert(String str) {
        if (this.ignore != FASTA) {
            if (str.length() > 0 && !this.ignorePattern.matcher(str).matches()) {
                this.strs[this.last++] = str;
                if (this.last == this.strs.length) {
                    this.expand();
                }
            }
        } else {
            if (this.current == null) {
                this.current = new StringBuffer();
            }
            if (str.length() > 0 && !this.ignorePattern.matcher(str).matches()) {
                this.current.append(str);
            } else if (str.length() > 0) {
                if (this.current.length() > 0) {
                    this.strs[this.last++] = this.current.toString();
                    if (this.last == this.strs.length) {
                        this.expand();
                    }
                }
                this.current.delete(0, this.current.length());
            }
        }
    }

    public String getAnnotation() {
        return this.annotation;
    }
}

