/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous;

public class CombinationIterator {
    private long[][] pascal;
    private int max;
    private int anz;
    private int[] currentCombi;

    public CombinationIterator(int n, int max) {
        int j = n - 1;
        int i = 0;
        int l = max + 1;
        this.max = max;
        this.anz = n;
        this.pascal = new long[n][l];
        for (i = 0; i < n; ++i) {
            this.pascal[i][0] = 1L;
        }
        for (i = n - 1; i >= 0; --i) {
            l = Math.min(max, n - i - 1);
            for (j = 1; j <= l; ++j) {
                this.pascal[i][j] = this.pascal[i + 1][j - 1] + this.pascal[i + 1][j];
            }
        }
    }

    public long getNumberOfCombinations(int elements) throws IllegalArgumentException {
        if (elements <= 0) {
            if (elements == 0) {
                return 0L;
            }
            throw new IllegalArgumentException("out of range.");
        }
        return this.pascal[0][elements] + this.pascal[0][elements - 1];
    }

    public void setCurrentLength(int current) throws IllegalArgumentException {
        if (current < 0 || current > this.max) {
            throw new IllegalArgumentException("The value has to be in [0," + this.max + "].");
        }
        this.currentCombi = new int[current];
        this.reset();
    }

    public boolean next() throws IllegalArgumentException {
        if (this.currentCombi == null) {
            throw new IllegalArgumentException("There is no length set (use method setCurrentLength).");
        }
        int counter1 = this.currentCombi.length - 1;
        int counter2 = 1;
        while (counter1 >= 0 && this.currentCombi[counter1] == this.anz - counter2) {
            --counter1;
            ++counter2;
        }
        if (counter1 < 0) {
            return false;
        }
        int n = counter1++;
        this.currentCombi[n] = this.currentCombi[n] + 1;
        while (counter1 < this.currentCombi.length) {
            this.currentCombi[counter1] = this.currentCombi[counter1 - 1];
            int n2 = counter1++;
            this.currentCombi[n2] = this.currentCombi[n2] + 1;
        }
        return true;
    }

    public int[] getCombination() {
        return (int[])this.currentCombi.clone();
    }

    public long getIndex(int[] combi) {
        long erg = this.pascal[combi[0]][combi.length];
        for (int i = 1; i < combi.length; ++i) {
            erg += this.pascal[combi[i]][combi.length - i];
        }
        return erg;
    }

    public void reset() throws IllegalArgumentException {
        if (this.currentCombi == null) {
            throw new IllegalArgumentException("There is no length set (use method setCurrentLength).");
        }
        for (int i = 0; i < this.currentCombi.length; i = (int)((byte)(i + 1))) {
            this.currentCombi[i] = i;
        }
    }
}

