/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.utils;

import de.jstacs.NotTrainedException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.models.Model;
import java.util.Random;

public class DiscreteInhomogenousSampleEmitter {
    public static Sample emitSample(Model m, int n) throws NotTrainedException, Exception {
        int counter3;
        int counter2;
        int counter1;
        if (!m.isTrained()) {
            throw new NotTrainedException();
        }
        AlphabetContainer alphabet = m.getAlphabetContainer();
        if (!alphabet.isDiscrete()) {
            throw new IllegalArgumentException("The models has to be discrete.");
        }
        int length = m.getLength();
        int il1 = 1;
        int il2 = 1;
        int l = 0;
        if (length == 0) {
            throw new IllegalArgumentException("The models has to be inhomogenous.");
        }
        int[] alphabetLength = new int[length + 1];
        boolean firstPart = true;
        for (counter1 = 0; counter1 < length; ++counter1) {
            alphabetLength[counter1] = (int)alphabet.getAlphabetLengthAt(counter1);
            if (firstPart && il1 < Integer.MAX_VALUE / alphabetLength[counter1]) {
                il1 *= alphabetLength[counter1];
                ++l;
                continue;
            }
            firstPart = false;
            if (il2 < Integer.MAX_VALUE / alphabetLength[counter1]) {
                il2 *= alphabetLength[counter1];
                continue;
            }
            new IllegalArgumentException("It is not possible to emit a sample of sequences with this length and alphabets by this implementation. (needs to much memory)");
        }
        alphabetLength[length] = 2;
        double p = 0.0;
        double[][] cumulative_p = new double[il2][il1];
        int[] sequence = new int[length + 1];
        for (counter2 = 0; counter2 < il2; ++counter2) {
            for (counter1 = 0; counter1 < il1; ++counter1) {
                cumulative_p[counter2][counter1] = p += m.getProbFor(new IntSequence(alphabet, sequence, 0, length));
                counter3 = 0;
                while (sequence[counter3] == alphabetLength[counter3] - 1) {
                    sequence[counter3++] = 0;
                }
                int n2 = counter3;
                sequence[n2] = sequence[n2] + 1;
            }
        }
        Random r = new Random();
        Sequence[] seqs = new Sequence[n];
        sequence = new int[length];
        for (int i = 0; i < n; ++i) {
            int max = il2 - 1;
            int min = -1;
            p = r.nextDouble();
            while (max - min > 1) {
                counter1 = (max + min) / 2;
                if (p >= cumulative_p[counter1][il1 - 1]) {
                    min = counter1;
                    continue;
                }
                max = counter1;
            }
            counter1 = max;
            max = il1 - 1;
            min = -1;
            while (max - min > 1) {
                counter2 = (max + min) / 2;
                if (p >= cumulative_p[counter1][counter2]) {
                    min = counter2;
                    continue;
                }
                max = counter2;
            }
            counter3 = counter2 = max;
            for (min = 0; min < l; ++min) {
                sequence[min] = counter3 % alphabetLength[min];
                counter3 /= alphabetLength[min];
            }
            counter3 = counter1;
            while (min < length) {
                sequence[min] = counter3 % alphabetLength[min];
                counter3 /= alphabetLength[min];
                ++min;
            }
            seqs[i] = new IntSequence(alphabet, sequence);
        }
        return new Sample("sampled from " + m.getInstanceName(), seqs);
    }
}

