/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

public final class DoubleList {
    private int size;
    private double[] array;

    public DoubleList() {
        this(10);
    }

    public DoubleList(int size) throws IllegalArgumentException {
        if (size <= 0) {
            throw new IllegalArgumentException("The size has to be positive.");
        }
        this.size = 0;
        this.array = new double[size];
    }

    public final void add(double val) {
        if (this.array.length == this.size) {
            double[] help = new double[2 * this.array.length];
            System.arraycopy(this.array, 0, help, 0, this.size);
            this.array = help;
        }
        this.array[this.size++] = val;
    }

    public final void add(double val, int fromIndex, int toIndex) {
        if (toIndex > this.array.length) {
            double[] help = new double[toIndex];
            System.arraycopy(this.array, 0, help, 0, this.size);
            this.array = help;
        }
        while (fromIndex < toIndex) {
            this.array[fromIndex++] = val;
        }
        if (this.size < toIndex) {
            this.size = toIndex;
        }
    }

    public final void clear() {
        this.size = 0;
    }

    public final double get(int index) {
        if (index < this.size) {
            return this.array[index];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public final int length() {
        return this.size;
    }

    public double[] toArray() {
        double[] erg = new double[this.size];
        System.arraycopy(this.array, 0, erg, 0, this.size);
        return erg;
    }

    public void multiply(int start, int end, double factor) {
        while (start < end) {
            int n = start++;
            this.array[n] = this.array[n] * factor;
        }
    }
}

