/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.assessment;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.classifier.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.data.Sample;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatedHoldOutAssessParameterSet
extends ClassifierAssessmentAssessParameterSet {
    protected RepeatedHoldOutAssessParameterSet(Class alternativeInstanceClass) {
        super(alternativeInstanceClass);
    }

    public RepeatedHoldOutAssessParameterSet() throws UnsupportedOperationException {
    }

    public RepeatedHoldOutAssessParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public RepeatedHoldOutAssessParameterSet(Sample.PartitionMethod dataSplitMethod, int elementLength, boolean exceptionIfMPNotComputable, int repeats, double[] percents) throws SimpleParameter.IllegalValueException {
        super(elementLength, exceptionIfMPNotComputable);
        ((Parameter)this.parameters.get(2)).setValue(new Integer(repeats));
        ParameterSet[] tempPSA = new ParameterSet[percents.length];
        int i = 0;
        while (i < tempPSA.length) {
            tempPSA[i] = this.getParameterSetContainingASingleDoubleValue(percents[i++]);
        }
        ((ExpandableParameterSet)((ParameterSetContainer)this.parameters.get(3)).getValue()).replaceContentWith(tempPSA);
        ((Parameter)this.parameters.get(4)).setValue((Object)dataSplitMethod);
    }

    private ParameterSet getParameterSetContainingASingleDoubleValue(double percent) throws SimpleParameter.IllegalValueException {
        ParameterSet ret = new ParameterSet(){

            protected void loadParameters() throws Exception {
                this.initParameterList(1);
                this.parameters.add(new SimpleParameter(DataType.DOUBLE, "percent", "Defines the percentage of the entire given data (for a specific class) should be used as test-data in a RepeatedHoldOutExperiment.", true, new NumberValidator<Double>(0.0, 1.0)));
            }

            public String getInstanceName() {
                return "";
            }

            public String getInstanceComment() {
                return "Contains only one Double-object. This double-value defines the percentage of the entire given data (for a specific class) should be used as test-data in a RepeatedHoldOutExperiment.";
            }
        };
        if (!Double.isNaN(percent)) {
            ret.getParameterAt(0).setValue(new Double(percent));
        }
        return ret;
    }

    @Override
    protected void initializeMyParametersArrayList() {
        this.initParameterList(5);
    }

    @Override
    protected void loadParameters() throws Exception {
        super.loadParameters();
        this.parameters.add(new SimpleParameter(DataType.INT, "repeats", "Determines how often the procedure of train/test classifers using random created train- and test-data should be repeated.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE)));
        this.parameters.add(new ParameterSetContainer("testDataPercentage", "A RepeatedHoldOutExperiment splits the given data (for each class) in each iteration into a test-part and a train-part. This ParameterSetcontainer contains an ExpandableParameterSet that contains for each class the percent of the entire data (for each class), that should be used as test-data. (1-percent) defines the percent of train-data.", new ExpandableParameterSet(null, this.getParameterSetContainingASingleDoubleValue(Double.NaN), "percent", "At pos i in this Expandable ParameterSet defines the percent of all given data, that should be used as test-data for class i in a RepeatedHoldOutExperiment.")));
        this.parameters.add(new EnumParameter(Sample.PartitionMethod.class, "The method used to compute the percentages of the partitions", true));
    }

    @Override
    public String getInstanceName() {
        return "RepeatedHoldOutExperiment";
    }

    @Override
    public String getInstanceComment() {
        return "This RepeatedHoldOutAssessParameterSet may be used to pass parameters into RepeatedHoldOutExperiment's method assess().";
    }

    public int getRepeats() {
        return (Integer)this.getParameterAt(2).getValue();
    }

    public double[] getPercents() {
        ExpandableParameterSet tempEPS = (ExpandableParameterSet)this.getParameterAt(3).getValue();
        double[] ret = new double[tempEPS.getNumberOfParameters()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Double)((ParameterSet)tempEPS.getParameterAt(i).getValue()).getParameterAt(0).getValue();
        }
        return ret;
    }

    public Sample.PartitionMethod getDataSplitMethod() {
        return (Sample.PartitionMethod)((EnumParameter)this.getParameterAt(4)).getValue();
    }

    @Override
    public Collection<Result> getAnnotation() {
        ArrayList<Result> l = new ArrayList<Result>(3);
        l.add(new NumericalResult("repeats", "The number of iterations", this.getRepeats()));
        l.add(new CategoricalResult("percentage", "The percentage of the entire data (for each class), that was used in an assessment", Arrays.toString(this.getPercents())));
        l.add(new CategoricalResult("dataSplitMethod", "Describes how data should be splitted in ClassiefierAssessment.evaluateClassifier())", this.getDataSplitMethod().name()));
        return l;
    }
}

