/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.DiscreteSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.SymbolExtractor;

public class IntSequence
extends DiscreteSequence {
    private int[] content;

    public IntSequence(AlphabetContainer alphabetContainer, int[] content) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, content, 0, content.length);
    }

    public IntSequence(AlphabetContainer alphabetContainer, int[] content, int start, int length) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer.getSubContainer(start, length), null);
        if (this.alphabetCon.getMaximalAlphabetLength() > 2.147483647E9) {
            throw new WrongSequenceTypeException();
        }
        this.content = new int[length];
        for (int i = 0; i < content.length; ++i) {
            if (!this.alphabetCon.isEncodedSymbol(i, content[start + i])) {
                throw new WrongAlphabetException();
            }
            this.content[i] = content[start + i];
        }
    }

    public IntSequence(AlphabetContainer alphabetContainer, String sequence) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, null, sequence, alphabetContainer.getDelim());
    }

    public IntSequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, String sequence, String delim) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, annotation, new SymbolExtractor(sequence, delim));
    }

    public IntSequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, SymbolExtractor extractor) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, annotation);
        if (alphabetContainer.getMaximalAlphabetLength() > 2.147483647E9) {
            throw new WrongSequenceTypeException();
        }
        this.content = new int[extractor.countElements()];
        for (int k = 0; k < this.content.length; ++k) {
            this.content[k] = (int)alphabetContainer.getCode(k, extractor.nextElement());
        }
    }

    private IntSequence(AlphabetContainer cont, SequenceAnnotation[] annotation, int[] content) throws WrongAlphabetException {
        super(cont, annotation);
        this.content = content;
    }

    public int discreteVal(int pos) {
        return this.content[pos];
    }

    public int getLength() {
        return this.content.length;
    }

    protected Sequence flatCloneWithoutAnnotation() {
        try {
            return new IntSequence(this.getAlphabetContainer(), null, this.content);
        }
        catch (Exception doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
    }
}

