/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import java.util.Arrays;

public abstract class Constraint
implements Storable {
    protected double[] counts;
    protected double[] freq;
    protected int[] usedPositions;

    public Constraint(int[] usedPositions, int n) {
        int i;
        int max = -1;
        for (i = 0; i < usedPositions.length; ++i) {
            if (usedPositions[i] < 0) {
                throw new IllegalArgumentException("The positions have to be non-negative.");
            }
            if (max >= usedPositions[i]) continue;
            max = usedPositions[i];
        }
        boolean[] used = new boolean[max + 1];
        for (i = 0; i < usedPositions.length; ++i) {
            if (used[usedPositions[i]]) {
                throw new IllegalArgumentException("Each position can be used only once, corrupted at " + usedPositions[i] + ".");
            }
            used[usedPositions[i]] = true;
        }
        this.usedPositions = (int[])usedPositions.clone();
        this.counts = new double[n];
        this.freq = new double[n];
    }

    public Constraint(StringBuffer xml) throws NonParsableException {
        StringBuffer erg = XMLParser.extractForTag(xml, this.getXMLTag());
        this.usedPositions = XMLParser.extractIntArrayForTag(erg, "usedPositions");
        this.counts = XMLParser.extractDoubleArrayForTag(erg, "counts");
        this.freq = XMLParser.extractDoubleArrayForTag(erg, "freq");
        this.extractAdditionalInfo(erg);
    }

    public void add(int index, double weight) {
        int n = index;
        this.counts[n] = this.counts[n] + weight;
    }

    public void add(Sequence seq, int start, double weight) {
        this.add(this.satisfiesSpecificConstraint(seq, start), weight);
    }

    protected Constraint clone() throws CloneNotSupportedException {
        Constraint p = (Constraint)super.clone();
        p.counts = (double[])this.counts.clone();
        p.freq = (double[])this.freq.clone();
        p.usedPositions = (int[])this.usedPositions.clone();
        return p;
    }

    public abstract void estimate(double var1);

    protected void estimateUnConditional(int start, int end, double pc, boolean exceptionWhenNoData) {
        double sum = 0.0;
        for (int index = start; index < end; ++index) {
            sum += this.counts[index];
        }
        if ((sum += (double)(end - start) * pc) <= 0.0) {
            if (exceptionWhenNoData) {
                throw new IllegalArgumentException("A marginal distribution returned an illegal value (" + sum + ").");
            }
            Arrays.fill(this.freq, start, end, 1.0 / (double)(end - start));
        } else {
            while (start < end) {
                this.freq[start] = (this.counts[start++] + pc) / sum;
            }
        }
    }

    protected abstract void appendAdditionalInfo(StringBuffer var1);

    public double getCount(int index) {
        return this.counts[index];
    }

    public double getFreq(int index) {
        return this.freq[index];
    }

    public double getFreq(Sequence seq, int start) {
        return this.getFreq(this.satisfiesSpecificConstraint(seq, start));
    }

    public int getMarginalOrder() {
        return this.usedPositions.length;
    }

    public int getNumberOfSpecificConstraints() {
        return this.counts.length;
    }

    public int getPosition(int index) {
        return this.usedPositions[index];
    }

    public int[] getPositions() {
        return (int[])this.usedPositions.clone();
    }

    protected abstract String getXMLTag();

    public void reset() {
        Arrays.fill(this.counts, 0.0);
        Arrays.fill(this.freq, 0.0);
    }

    public abstract int satisfiesSpecificConstraint(Sequence var1, int var2);

    protected abstract void extractAdditionalInfo(StringBuffer var1) throws NonParsableException;

    public abstract String toString();

    public StringBuffer toXML() {
        StringBuffer erg = new StringBuffer(10000);
        XMLParser.appendIntArrayWithTags(erg, this.usedPositions, "usedPositions");
        XMLParser.appendDoubleArrayWithTags(erg, this.counts, "counts");
        XMLParser.appendDoubleArrayWithTags(erg, this.freq, "freq");
        this.appendAdditionalInfo(erg);
        XMLParser.addTags(erg, this.getXMLTag());
        return erg;
    }
}

