/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.AlphabetContainerParameterSet;
import de.jstacs.models.discrete.DiscreteGraphicalModel;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DGMParameterSet
extends InstanceParameterSet {
    protected DGMParameterSet(StringBuffer s) throws NonParsableException {
        super(s);
    }

    protected DGMParameterSet(Class<? extends DiscreteGraphicalModel> instanceClass, boolean simple, boolean variableLength) {
        super(instanceClass, true, simple, variableLength);
    }

    protected DGMParameterSet(Class<? extends DiscreteGraphicalModel> instanceClass, AlphabetContainer alphabet, double ess, String description) throws Exception {
        this(instanceClass, alphabet, 0, true, ess, description);
    }

    protected DGMParameterSet(Class<? extends DiscreteGraphicalModel> instanceClass, AlphabetContainer alphabet, int length, double ess, String description) throws Exception {
        this(instanceClass, alphabet, length, false, ess, description);
    }

    private DGMParameterSet(Class<? extends DiscreteGraphicalModel> instanceClass, AlphabetContainer alphabet, int length, boolean variableLength, double ess, String description) throws Exception {
        super(instanceClass, alphabet, length, variableLength);
        this.loadParameters();
        this.setEss(ess);
        if (description != null) {
            ((Parameter)this.parameters.get(1)).setValue(description);
        }
    }

    @Override
    protected void loadParameters() throws Exception {
        this.initParameterList();
        this.parameters.add(new SimpleParameter(DataType.DOUBLE, "ESS", "the equivalent sample size", true, new NumberValidator<Double>(new Double(0.0), new Double(Double.MAX_VALUE))));
        this.parameters.add(new SimpleParameter(DataType.STRING, "description", "a textual description or comment for the model", false, "none"));
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        if (super.hasDefaultOrIsSet()) {
            return ((AlphabetContainerParameterSet)this.alphabet.getValue()).isDiscrete();
        }
        return false;
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public DGMParameterSet clone() throws CloneNotSupportedException {
        return (DGMParameterSet)super.clone();
    }

    public void setEss(double ess) throws SimpleParameter.IllegalValueException {
        ((Parameter)this.parameters.get(0)).setValue(ess);
    }
}

