/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.utils;

import org.biojava.bio.structure.jama.EigenvalueDecomposition;
import org.biojava.bio.structure.jama.Matrix;

public class StationaryDistribution {
    public static double[] getStationaryDistribution(double[] condProbs, int alphabetSize) {
        int i;
        if (condProbs.length % alphabetSize != 0) {
            throw new IllegalArgumentException("wrong dimension");
        }
        int dim = condProbs.length / alphabetSize;
        double[][] matrix = new double[dim][dim];
        int help = dim / alphabetSize;
        for (int i2 = 0; i2 < dim; ++i2) {
            int offset1 = i2 / alphabetSize;
            int offset2 = i2 % alphabetSize;
            for (int j = 0; j < alphabetSize; ++j) {
                int h = offset1 + j * help;
                matrix[i2][h] = condProbs[h * alphabetSize + offset2];
            }
        }
        Matrix m = new Matrix(matrix, dim, dim);
        EigenvalueDecomposition eigen = new EigenvalueDecomposition(m);
        int ind = StationaryDistribution.getIndex(eigen.getRealEigenvalues(), 1.0);
        Matrix m2 = eigen.getV().getMatrix(0, dim - 1, ind, ind).transpose();
        double[] res = m2.getArray()[0];
        double sum = 0.0;
        for (i = 0; i < dim; ++i) {
            sum += res[i];
        }
        i = 0;
        while (i < dim) {
            int n = i++;
            res[n] = res[n] / sum;
        }
        return res;
    }

    private static int getIndex(double[] eigenValues, double wanted) {
        int best = 0;
        double diff = Math.abs(1.0 - eigenValues[best]);
        for (int i = 1; i < eigenValues.length; ++i) {
            double current = Math.abs(1.0 - eigenValues[i]);
            if (!(current < diff)) continue;
            best = i;
            diff = current;
        }
        return best;
    }

    public static double[] getStationarySymbolDistribution(double[] probs, int alphabetSize) {
        double[] help = (double[])probs.clone();
        while (help.length > alphabetSize) {
            StationaryDistribution.makeCondProb(help, alphabetSize);
            help = StationaryDistribution.getStationaryDistribution(help, alphabetSize);
        }
        return help;
    }

    private static void makeCondProb(double[] jointProb, int alphabetSize) {
        int i = 0;
        while (i < jointProb.length) {
            int j;
            double sum = 0.0;
            for (j = 0; j < alphabetSize; ++j) {
                sum += jointProb[i + j];
            }
            for (j = 0; j < alphabetSize; ++j) {
                int n = i++;
                jointProb[n] = jointProb[n] / sum;
            }
        }
    }

    private static void show(double[] condProb, int alphabetSize) {
        int i = 0;
        while (i < condProb.length) {
            int j = 0;
            while (j < alphabetSize) {
                System.out.print(condProb[i] + "\t");
                ++j;
                ++i;
            }
            System.out.println();
        }
    }

    private static void show(double[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                System.out.print(matrix[i][j] + "\t");
            }
            System.out.println();
        }
    }
}

