/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSet
implements Storable {
    protected Result[] results;

    public ResultSet(Result result) {
        this.results = new Result[]{result};
    }

    public ResultSet(Result[] ... results) {
        if (results == null) {
            this.results = new Result[0];
        } else {
            int i;
            int c = 0;
            for (i = 0; i < results.length; ++i) {
                c += results[i] == null ? 0 : results[i].length;
            }
            this.results = new Result[c];
            c = 0;
            for (i = 0; i < results.length; ++i) {
                if (results[i] == null) continue;
                System.arraycopy(results[i], 0, this.results, c, results[i].length);
                c += results[i].length;
            }
        }
    }

    public ResultSet(Collection<? extends Result> results) {
        this.results = results.toArray(new Result[0]);
    }

    public ResultSet(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    public Result getResultAt(int index) {
        return this.results[index];
    }

    public Result[] getResults() {
        Result[] res = new Result[this.results.length];
        System.arraycopy(this.results, 0, res, 0, res.length);
        return res;
    }

    public int getNumberOfResults() {
        return this.results.length;
    }

    @Override
    public StringBuffer toXML() {
        String[] resStrings = new String[this.results.length];
        for (int i = 0; i < this.results.length; ++i) {
            StringBuffer b = new StringBuffer();
            XMLParser.appendStringWithTags(b, this.results[i].getClass().getName(), "className");
            XMLParser.appendStringWithTags(b, this.results[i].toXML().toString(), "result");
            resStrings[i] = b.toString();
        }
        StringBuffer buf = new StringBuffer();
        XMLParser.appendStringArrayWithTags(buf, resStrings, "resStrings");
        XMLParser.addTags(buf, "resultSet");
        return buf;
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "resultSet");
        String[] resStrings = XMLParser.extractStringArrayForTag(representation, "resStrings");
        this.results = new Result[resStrings.length];
        try {
            for (int i = 0; i < this.results.length; ++i) {
                StringBuffer b = new StringBuffer(resStrings[i]);
                String className = XMLParser.extractStringForTag(b, "className");
                Class<?> c = Class.forName(className);
                this.results[i] = (Result)c.getConstructor(StringBuffer.class).newInstance(XMLParser.extractForTag(b, "result"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NonParsableException(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer help = new StringBuffer(100 * this.results.length);
        for (int i = 0; i < this.results.length; ++i) {
            help.append(this.results[i].toString() + "\n");
        }
        return help.toString();
    }

    public int findColumn(String columnName) {
        for (int i = 0; i < this.results.length; ++i) {
            if (!this.results[i].getName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }
}

