/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures;

import de.jstacs.NonParsableException;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.Measure;

public class InhomogeneousMarkov
extends Measure {
    private int order;

    public InhomogeneousMarkov(int order) {
        this.order = order;
    }

    public InhomogeneousMarkov(StringBuffer buf) throws NonParsableException {
        buf = XMLParser.extractForTag(buf, "inhomogeneousMarkov");
        this.order = XMLParser.extractIntForTag(buf, "order");
    }

    public int getOrder() {
        return this.order;
    }

    public InhomogeneousMarkov clone() throws CloneNotSupportedException {
        return (InhomogeneousMarkov)super.clone();
    }

    public String getInstanceName() {
        return "Inhomogeneous Markov model of order " + this.order;
    }

    public int[][] getParents(Sample fg, Sample bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        int[][] parents = new int[length][];
        for (int i = 0; i < parents.length; ++i) {
            parents[i] = new int[(this.order < i ? this.order : i) + 1];
            for (int j = i; j >= i - this.order && j >= 0; --j) {
                parents[i][parents[i].length - (i - j) - 1] = j;
            }
        }
        return parents;
    }

    public boolean isShiftable() {
        return true;
    }

    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendIntWithTags(buf, this.order, "order");
        XMLParser.addTags(buf, "inhomogeneousMarkov");
        return buf;
    }
}

