/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.integration.OdeSolverBasedIntegrator;
import de.jtem.numericalMethods.calculus.odeSolving.Extrap;

public final class ExtrapIntegrator
extends OdeSolverBasedIntegrator {
    private static final long serialVersionUID = 1L;
    double initialStepSize = 0.1;
    double absTol = 1.0E-7;
    double relTol = 1.0E-7;
    private boolean justStarted = false;

    public ExtrapIntegrator() {
        super(new Extrap());
    }

    public ExtrapIntegrator(RealFunctionOfOneVariable realFunctionOfOneVariable) {
        super(new Extrap(1));
        this.setFunction(realFunctionOfOneVariable);
    }

    public ExtrapIntegrator(RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable) {
        super(new Extrap(realVectorValuedFunctionOfOneVariable.getDimensionOfTargetSpace()));
        this.setFunction(realVectorValuedFunctionOfOneVariable);
    }

    public double getInitialStepSize() {
        return this.initialStepSize;
    }

    public void setInitialStepSize(double d) {
        if (this.initialStepSize == d) {
            return;
        }
        this.initialStepSize = d;
    }

    public void setEps(double d) {
        ((Extrap)this.odeSolver).setAbsTol(d);
        ((Extrap)this.odeSolver).setRelTol(d);
        this.absTol = d;
        this.relTol = d;
    }

    public double getAbsTol() {
        return this.absTol;
    }

    public void setAbsTol(double d) {
        ((Extrap)this.odeSolver).setAbsTol(d);
        if (this.absTol == d) {
            return;
        }
        this.absTol = d;
    }

    public double getRelTol() {
        return this.relTol;
    }

    public void setRelTol(double d) {
        ((Extrap)this.odeSolver).setRelTol(d);
        if (this.relTol == d) {
            return;
        }
        this.relTol = d;
    }

    public void startAt(double d) {
        super.startAt(d);
        this.justStarted = true;
    }

    public void integrateTo(double d) {
        if (this.justStarted) {
            ((Extrap)this.odeSolver).setCurrentStepSize(this.initialStepSize);
        }
        super.integrateTo(d);
        this.justStarted = false;
    }

    public static double integrate(RealFunctionOfOneVariable realFunctionOfOneVariable, double d, double d2) {
        return ExtrapIntegrator.integrate(realFunctionOfOneVariable, d, d2, 1.0E-14);
    }

    public static double integrate(RealFunctionOfOneVariable realFunctionOfOneVariable, double d, double d2, double d3) {
        ExtrapIntegrator extrapIntegrator = new ExtrapIntegrator(realFunctionOfOneVariable);
        extrapIntegrator.setAbsTol(d3);
        extrapIntegrator.setRelTol(d3);
        return extrapIntegrator.integrate(d, d2);
    }

    public static void integrate(RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable, double[] dArray, double d, double d2) {
        ExtrapIntegrator.integrate(dArray, realVectorValuedFunctionOfOneVariable, d, d2, 1.0E-14);
    }

    public static void integrate(double[] dArray, RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable, double d, double d2, double d3) {
        ExtrapIntegrator extrapIntegrator = new ExtrapIntegrator(realVectorValuedFunctionOfOneVariable);
        extrapIntegrator.setAbsTol(d3);
        extrapIntegrator.setRelTol(d3);
        extrapIntegrator.integrate(d, d2, dArray);
    }
}

