/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.assessment;

import de.jstacs.WrongAlphabetException;
import de.jstacs.classifier.AbstractClassifier;
import de.jstacs.classifier.ClassDimensionException;
import de.jstacs.classifier.MeasureParameters;
import de.jstacs.classifier.assessment.ClassifierAssessment;
import de.jstacs.classifier.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.classifier.assessment.RepeatedHoldOutAssessParameterSet;
import de.jstacs.data.Sample;
import de.jstacs.models.Model;
import de.jstacs.utils.ProgressUpdater;

public class RepeatedHoldOutExperiment
extends ClassifierAssessment {
    protected RepeatedHoldOutExperiment(AbstractClassifier[] aCs, Model[][] aMs, boolean buildClassifiersByCrossProduct, boolean checkAlphabetConsistencyAndLength) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, aMs, buildClassifiersByCrossProduct, checkAlphabetConsistencyAndLength);
    }

    public RepeatedHoldOutExperiment(AbstractClassifier ... aCs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs);
    }

    public RepeatedHoldOutExperiment(boolean buildClassifiersByCrossProduct, Model[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(buildClassifiersByCrossProduct, aMs);
    }

    public RepeatedHoldOutExperiment(AbstractClassifier[] aCs, boolean buildClassifiersByCrossProduct, Model[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, buildClassifiersByCrossProduct, aMs);
    }

    protected boolean evaluateClassifier(MeasureParameters mp, ClassifierAssessmentAssessParameterSet assessPS, Sample[] s, ProgressUpdater pU) throws IllegalArgumentException, Exception {
        RepeatedHoldOutAssessParameterSet tempAssessPS = null;
        try {
            tempAssessPS = (RepeatedHoldOutAssessParameterSet)assessPS;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Given AssessParameterSet assessPS is not of type RepeatedHoldOutAssessParameterSet.");
        }
        Sample.PartitionMethod splitMethod = tempAssessPS.getDataSplitMethod();
        int subSeqL = tempAssessPS.getElementLength();
        boolean exceptionIfMPNotComputable = tempAssessPS.getExceptionIfMPNotComputable();
        int repeats = tempAssessPS.getRepeats();
        double[] percents = tempAssessPS.getPercents();
        if (percents.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Given RepeatedHoldOutAssessParameterSet contains a invalid parameter percents. Percents (double[], percentage of test-data of all given class specific data) must contain as much entries as classes the local classifers are able to distinguish.");
        }
        Sample[][] sTrainTestClassWise = new Sample[2][s.length];
        pU.setMax(repeats);
        for (int iteration = 0; iteration < repeats; ++iteration) {
            for (int classes = 0; classes < s.length; ++classes) {
                Sample[] temp = s[classes].partition(percents[classes], splitMethod, subSeqL);
                sTrainTestClassWise[0][classes] = temp[0];
                sTrainTestClassWise[1][classes] = temp[1];
            }
            this.train(sTrainTestClassWise[0]);
            this.test(mp, exceptionIfMPNotComputable, sTrainTestClassWise[1]);
            pU.setValue(iteration + 1);
            if (pU.isCancelled()) break;
        }
        return true;
    }
}

