/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased.logPrior;

import de.jstacs.NonParsableException;
import de.jstacs.classifier.scoringFunctionBased.logPrior.LogPrior;
import de.jstacs.io.XMLParser;

public class SimpleGaussianSumLogPrior
extends LogPrior {
    private double sigmaSq;

    public SimpleGaussianSumLogPrior(double sigma) {
        this.sigmaSq = sigma * sigma;
    }

    public SimpleGaussianSumLogPrior(StringBuffer xml) throws NonParsableException {
        StringBuffer content = XMLParser.extractForTag(xml, "SimpleGaussianProductPrior");
        this.sigmaSq = XMLParser.extractDoubleForTag(content, "sigmaSquared");
    }

    public void addGradientFor(double[] params, double[] grad) {
        for (int i = 0; i < params.length; ++i) {
            int n = i;
            grad[n] = grad[n] - params[i] / this.sigmaSq;
        }
    }

    public double evaluateFunction(double[] params) {
        double erg = 0.0;
        for (int i = 0; i < params.length; ++i) {
            erg -= params[i] * params[i];
        }
        return erg / (2.0 * this.sigmaSq);
    }

    public int getDimensionOfScope() {
        return -1;
    }

    public SimpleGaussianSumLogPrior getNewInstance() throws CloneNotSupportedException {
        SimpleGaussianSumLogPrior newI = new SimpleGaussianSumLogPrior(0.0);
        newI.sigmaSq = this.sigmaSq;
        return newI;
    }

    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(300);
        XMLParser.appendDoubleWithTags(xml, this.sigmaSq, "sigmaSquared");
        XMLParser.addTags(xml, "SimpleGaussianProductPrior");
        return xml;
    }

    public String getInstanceName() {
        return "Gaussian product prior";
    }
}

