/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.data.Alphabet;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ArrayParameterSet;
import de.jstacs.parameters.CollectionParameter;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import java.util.Iterator;
import java.util.LinkedList;

public class AlphabetContainerParameterSet
extends ParameterSet {
    private boolean discrete;
    private boolean simple;

    public AlphabetContainerParameterSet(boolean discrete, boolean simple) {
        super(AlphabetContainer.class);
        this.discrete = discrete;
        this.simple = simple;
    }

    public AlphabetContainerParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public AlphabetContainerParameterSet(Alphabet alph) throws Exception {
        super(AlphabetContainer.class);
        this.discrete = alph instanceof DiscreteAlphabet;
        this.simple = true;
        this.loadParameters();
        if (this.discrete) {
            ((Parameter)this.parameters.get(0)).setValue(alph.getCurrentParameterSet());
        } else {
            ParameterSet ap = alph.getCurrentParameterSet();
            ((Parameter)this.parameters.get(0)).setValue(ap.getInstanceName());
            ((CollectionParameter)this.parameters.get(0)).getParametersInCollection().getParameterAt(((CollectionParameter)this.parameters.get(0)).getSelected()).setValue(ap);
        }
    }

    public AlphabetContainerParameterSet(Alphabet[] alphabets) throws Exception {
        super(AlphabetContainer.class);
        this.simple = false;
        this.discrete = true;
        for (int i = 0; i < alphabets.length; ++i) {
            this.discrete &= alphabets[i] instanceof DiscreteAlphabet;
        }
        this.loadParameters();
        AlphabetArrayParameterSet pars = new AlphabetArrayParameterSet(alphabets, this.discrete);
        ((Parameter)this.parameters.get(0)).setValue(pars.getInstanceName());
        ((CollectionParameter)this.parameters.get(0)).getParametersInCollection().getParameterAt(((CollectionParameter)this.parameters.get(0)).getSelected()).setValue(pars);
    }

    public AlphabetContainerParameterSet(Alphabet[] alphabets, int[] indexes) throws Exception {
        super(AlphabetContainer.class);
        this.simple = false;
        this.discrete = true;
        for (int i = 0; i < alphabets.length; ++i) {
            this.discrete &= alphabets[i] instanceof DiscreteAlphabet;
        }
        this.loadParameters();
        SectionDefinedAlphabetParameterSet pars = new SectionDefinedAlphabetParameterSet(alphabets, indexes, this.discrete);
        ((Parameter)this.parameters.get(0)).setValue(pars.getInstanceName());
        ((CollectionParameter)this.parameters.get(0)).getParametersInCollection().getParameterAt(((CollectionParameter)this.parameters.get(0)).getSelected()).setValue(pars);
    }

    public AlphabetContainerParameterSet clone() throws CloneNotSupportedException {
        AlphabetContainerParameterSet clone = (AlphabetContainerParameterSet)super.clone();
        return clone;
    }

    public boolean isDiscrete() {
        return this.discrete;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameters");
        XMLParser.appendBooleanWithTags(buf, this.discrete, "discrete");
        XMLParser.appendBooleanWithTags(buf, this.simple, "simple");
        XMLParser.addTags(buf, "alphabetContainerParameterSet");
        return buf;
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "alphabetContainerParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
        this.discrete = XMLParser.extractBooleanForTag(representation, "discrete");
        this.simple = XMLParser.extractBooleanForTag(representation, "simple");
    }

    public int getPossibleLength() {
        Object o = ((Parameter)this.parameters.get(0)).getValue();
        if (o instanceof DNAAlphabet.DNAAlphabetParameterSet || o instanceof DiscreteAlphabet.DiscreteAlphabetParameterSet || o instanceof ContinuousAlphabet.ContinuousAlphabetParameterSet) {
            return 0;
        }
        ParameterSet set = (ParameterSet)o;
        return (Integer)set.getParameterAt(0).getValue();
    }

    protected void loadParameters() throws Exception {
        DiscreteAlphabet.DiscreteAlphabetParameterSet simpleDisc = new DiscreteAlphabet.DiscreteAlphabetParameterSet();
        ContinuousAlphabet.ContinuousAlphabetParameterSet simpleCont = new ContinuousAlphabet.ContinuousAlphabetParameterSet();
        Object[] vals = null;
        String[] names = null;
        String[] comments = null;
        if (this.simple && this.discrete) {
            this.initParameterList();
            this.parameters.add(new ParameterSetContainer("Alphabet", "Set a discrete alphabet.", simpleDisc));
        } else {
            if (!this.discrete && this.simple) {
                vals = new Object[]{simpleDisc, simpleCont};
                names = new String[]{((ParameterSet)simpleDisc).getInstanceName(), ((ParameterSet)simpleCont).getInstanceName()};
                comments = new String[]{((ParameterSet)simpleDisc).getInstanceComment(), ((ParameterSet)simpleCont).getInstanceComment()};
            } else {
                AlphabetArrayParameterSet arrayParameters = new AlphabetArrayParameterSet(this.discrete);
                SectionDefinedAlphabetParameterSet sectionParameters = new SectionDefinedAlphabetParameterSet(this.discrete);
                if (!this.discrete) {
                    vals = new Object[]{simpleDisc, simpleCont, arrayParameters, sectionParameters};
                    names = new String[]{((ParameterSet)simpleDisc).getInstanceName(), ((ParameterSet)simpleCont).getInstanceName(), ((ParameterSet)arrayParameters).getInstanceName(), ((ParameterSet)sectionParameters).getInstanceName()};
                    comments = new String[]{((ParameterSet)simpleDisc).getInstanceComment(), ((ParameterSet)simpleCont).getInstanceComment(), ((ParameterSet)arrayParameters).getInstanceComment(), ((ParameterSet)sectionParameters).getInstanceComment()};
                } else {
                    vals = new Object[]{simpleDisc, arrayParameters, sectionParameters};
                    names = new String[]{((ParameterSet)simpleDisc).getInstanceName(), ((ParameterSet)arrayParameters).getInstanceName(), ((ParameterSet)sectionParameters).getInstanceName()};
                    comments = new String[]{((ParameterSet)simpleDisc).getInstanceComment(), ((ParameterSet)arrayParameters).getInstanceComment(), ((ParameterSet)sectionParameters).getInstanceComment()};
                }
            }
            this.initParameterList();
            this.parameters.add(new CollectionParameter(DataType.PARAMETERSET, names, vals, comments, "Type", "Select the type of the alphabet", true));
        }
    }

    public String getInstanceName() {
        return "Alphabet";
    }

    public String getInstanceComment() {
        return "Set an alphabet for your model or data.";
    }

    public static class AlphabetArrayParameterSet
    extends ArrayParameterSet {
        private boolean discrete;

        public AlphabetArrayParameterSet(boolean discrete) throws Exception {
            super(null, discrete ? new DiscreteAlphabet.DiscreteAlphabetParameterSet() : new SimpleParameterSet(new Parameter[]{new CollectionParameter(new ParameterSet[]{new DiscreteAlphabet.DiscreteAlphabetParameterSet(), new ContinuousAlphabet.ContinuousAlphabetParameterSet()}, "Type of alphabet", "Select the type of the alphabet", true)}), "Alphabet", "Set the alphabet");
        }

        public AlphabetArrayParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        public AlphabetArrayParameterSet(Alphabet[] alphabets, boolean discrete) throws Exception {
            this(discrete);
            this.loadParameters();
            ((Parameter)this.parameters.get(0)).setValue(alphabets.length);
            this.loadParameters();
            for (int i = 0; i < alphabets.length; ++i) {
                if (discrete) {
                    ((Parameter)this.parameters.get(i + 1)).setValue(alphabets[i].getCurrentParameterSet());
                    continue;
                }
                ParameterSet ap = alphabets[i].getCurrentParameterSet();
                ((ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue()).getParameterAt(0).setValue(ap.getInstanceName());
                ((CollectionParameter)((ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue()).getParameterAt(0)).getParametersInCollection().getParameterAt(((CollectionParameter)((ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue()).getParameterAt(0)).getSelected()).setValue(ap);
            }
        }

        public AlphabetArrayParameterSet clone() throws CloneNotSupportedException {
            try {
                AlphabetArrayParameterSet clone = (AlphabetArrayParameterSet)super.clone();
                return clone;
            }
            catch (Exception e) {
                throw new CloneNotSupportedException(e.getCause().getMessage());
            }
        }

        public StringBuffer toXML() {
            StringBuffer buf = super.toXML();
            XMLParser.addTags(buf, "superParameters");
            XMLParser.appendBooleanWithTags(buf, this.discrete, "discrete");
            XMLParser.addTags(buf, "alphabetArrayParameterSet");
            return buf;
        }

        public void fromXML(StringBuffer representation) throws NonParsableException {
            representation = XMLParser.extractForTag(representation, "alphabetArrayParameterSet");
            super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
            this.discrete = XMLParser.extractBooleanForTag(representation, "discrete");
        }

        public String getInstanceName() {
            return "Alphabet-array";
        }

        public String getInstanceComment() {
            return "An array of alphabets where each position can have its own alphabet.";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SectionDefinedAlphabetParameterSet
    extends ExpandableParameterSet {
        private boolean discrete;

        public SectionDefinedAlphabetParameterSet(boolean discrete) throws Exception {
            super(null, new SimpleParameterSet(new Parameter[]{discrete ? new ParameterSetContainer("Alphabet", "Set the parameters of the alphabet.", new DiscreteAlphabet.DiscreteAlphabetParameterSet()) : new CollectionParameter(new ParameterSet[]{new DiscreteAlphabet.DiscreteAlphabetParameterSet(), new ContinuousAlphabet.ContinuousAlphabetParameterSet()}, "Type of alphabet", "Select the type of the alphabet", true), new SimpleParameter(DataType.STRING, "Section", "The section for that this alphabet is applied. Use &quot;,&quot; to separate different positions and &quot;-&quot; to indicate ranges, e.g. 1-3,5.", true)}), "Alphabet", "Set the alphabet");
            this.template.getParameterAt(1).setNeededReference(this);
            this.discrete = discrete;
        }

        public SectionDefinedAlphabetParameterSet(Alphabet[] alphabets, int[] indexes, boolean discrete) throws Exception {
            this(discrete);
            int i;
            this.loadParameters();
            ((Parameter)this.parameters.get(0)).setValue(indexes.length);
            for (i = 0; i < alphabets.length; ++i) {
                this.addParameterToSet();
            }
            for (i = 0; i < alphabets.length; ++i) {
                ParameterSet temp = (ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue();
                if (discrete) {
                    temp.getParameterAt(0).setValue(alphabets[i].getCurrentParameterSet());
                } else {
                    ParameterSet ap = alphabets[i].getCurrentParameterSet();
                    temp.getParameterAt(0).setValue(ap.getInstanceName());
                    ((CollectionParameter)temp.getParameterAt(0)).getParametersInCollection().getParameterAt(((CollectionParameter)temp.getParameterAt(0)).getSelected()).setValue(ap);
                }
                StringBuffer sections = new StringBuffer();
                for (int j = 0; j < indexes.length; ++j) {
                    if (indexes[j] != i) continue;
                    sections.append(j + 1 + ", ");
                }
                sections.delete(sections.length() - 2, sections.length());
                temp.getParameterAt(1).setValue(sections.toString());
            }
        }

        public SectionDefinedAlphabetParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        @Override
        protected void loadParameters() throws Exception {
            this.initParameterList();
            SimpleParameter length = new SimpleParameter(DataType.INT, "Length", "The length of the array.", true);
            length.setRangeable(false);
            length.setNeededReference(this);
            this.parameters.add(length);
            super.loadParameters();
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer buf = super.toXML();
            XMLParser.addTags(buf, "superParameters");
            XMLParser.appendBooleanWithTags(buf, this.discrete, "discrete");
            XMLParser.addTags(buf, "sectionDefinedAlphabetParameterSet");
            return buf;
        }

        @Override
        public void fromXML(StringBuffer representation) throws NonParsableException {
            representation = XMLParser.extractForTag(representation, "sectionDefinedAlphabetParameterSet");
            super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
            if (this.parameters != null) {
                ((Parameter)this.parameters.get(0)).setNeededReference(this);
                for (int i = 1; i < this.parameters.size(); ++i) {
                    ((ParameterSetContainer)this.parameters.get(i)).getValue().getParameterAt(1).setNeededReference(this);
                }
            }
            this.discrete = XMLParser.extractBooleanForTag(representation, "discrete");
        }

        @Override
        public boolean hasDefaultOrIsSet() {
            if (!super.hasDefaultOrIsSet()) {
                return false;
            }
            Iterator it = this.parameters.iterator();
            boolean[] set = new boolean[((Integer)((Parameter)it.next()).getValue()).intValue()];
            int no = 0;
            while (it.hasNext()) {
                ++no;
                ParameterSet temp = (ParameterSet)((Parameter)it.next()).getValue();
                String section = (String)temp.getParameterAt(1).getValue();
                try {
                    LinkedList<Integer> tempList = SectionDefinedAlphabetParameterSet.parseSections(section);
                    Iterator posIt = tempList.iterator();
                    while (posIt.hasNext()) {
                        int curr = (Integer)posIt.next();
                        if (curr >= set.length) {
                            this.errorMessage = "Position " + (curr + 1) + " out of range defined by length.";
                            return false;
                        }
                        if (set[curr]) {
                            this.errorMessage = "Alphabet for position " + (curr + 1) + " defined at least twice.";
                            return false;
                        }
                        set[curr] = true;
                    }
                }
                catch (Exception e) {
                    this.errorMessage = "Malformed section definition no. " + no;
                    e.printStackTrace();
                    return false;
                }
            }
            for (int i = 0; i < set.length; ++i) {
                if (set[i]) continue;
                this.errorMessage = "No alphabet defined for position " + (i + 1) + ".";
                return false;
            }
            this.errorMessage = null;
            return true;
        }

        public static LinkedList<Integer> parseSections(String sections) throws Exception {
            String[] secs = sections.split("(\\s*,\\s*)");
            LinkedList<Integer> list = new LinkedList<Integer>();
            for (int i = 0; i < secs.length; ++i) {
                String[] temp = secs[i].split("(\\s*-\\s*)");
                if (temp.length == 2) {
                    int end;
                    int start = Integer.parseInt(temp[0]) - 1;
                    start = start <= (end = Integer.parseInt(temp[1]) - 1) ? start : end;
                    int n = end = end >= start ? end : start;
                    if (start < 0) {
                        throw new Exception("Malformed sections, no negative values allowed.");
                    }
                    for (int j = start; j <= end; ++j) {
                        list.add(j);
                    }
                    continue;
                }
                if (temp.length == 1) {
                    int pos = Integer.parseInt(temp[0]) - 1;
                    if (pos < 0) {
                        throw new Exception("Malformed sections, no negative values allowed.");
                    }
                    list.add(pos);
                    continue;
                }
                throw new Exception("Malformed sections.");
            }
            return list;
        }

        @Override
        public SectionDefinedAlphabetParameterSet clone() throws CloneNotSupportedException {
            try {
                SectionDefinedAlphabetParameterSet clone = (SectionDefinedAlphabetParameterSet)super.clone();
                if (clone.parameters != null) {
                    ((Parameter)clone.parameters.get(0)).setNeededReference(clone);
                    for (int i = 1; i < clone.parameters.size(); ++i) {
                        ((ParameterSetContainer)clone.parameters.get(i)).getValue().getParameterAt(1).setNeededReference(clone);
                    }
                }
                return clone;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CloneNotSupportedException(e.getCause().getMessage());
            }
        }

        @Override
        public String getInstanceName() {
            return "Alphabets defined by section";
        }

        @Override
        public String getInstanceComment() {
            return "Set the alphabets for all positions.";
        }
    }
}

