/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLParser {
    public static StringBuffer extractForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractForTag(source, tag, tag);
    }

    public static StringBuffer extractForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        if (source == null || source.length() == 0) {
            return null;
        }
        int start = source.indexOf("<" + startTag + ">");
        if (start == -1) {
            return null;
        }
        int end = start += startTag.length() + 2;
        int pos = start;
        int open = 1;
        while ((pos = source.indexOf(endTag, pos + 1)) > 0) {
            if (source.charAt(pos - 1) == '/' && source.charAt(pos - 2) == '<') {
                --open;
            } else if (source.charAt(pos - 1) == '<') {
                ++open;
            }
            if (open != 0) continue;
            end = pos - 2;
            break;
        }
        if (pos == -1) {
            throw new NonParsableException("Missing end tag for: " + endTag);
        }
        StringBuffer ex = new StringBuffer(source.substring(start, end));
        source.delete(start - startTag.length() - 2, end + endTag.length() + 3);
        return ex;
    }

    public static boolean extractBooleanForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractBooleanForTag(source, startTag, startTag);
    }

    public static boolean extractBooleanForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        return Boolean.valueOf(XMLParser.extractForTag(source, startTag, endTag).toString().trim());
    }

    public static byte extractByteForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractByteForTag(source, startTag, startTag);
    }

    public static byte extractByteForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        try {
            return Byte.parseByte(ex.toString());
        }
        catch (NumberFormatException e) {
            throw new NonParsableException("Could not parse \"" + startTag + "\" to int.");
        }
        catch (NullPointerException e) {
            throw new NonParsableException("Could not find \"" + startTag + "\".");
        }
    }

    public static <T extends Enum<T>> T extractEnumForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractEnumForTag(source, tag, tag);
    }

    public static <T extends Enum<T>> T extractEnumForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        Object erg;
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        if (ex == null) {
            throw new NonParsableException("Could not find \"" + startTag + "\".");
        }
        String enumName = XMLParser.extractStringForTag(ex, "enumName");
        try {
            erg = Enum.valueOf(Class.forName(enumName), XMLParser.extractStringForTag(ex, "name"));
        }
        catch (Exception e) {
            throw XMLParser.getNonParsableException("problem at " + enumName + ": " + e.getClass().getSimpleName() + ": " + e.getCause().toString(), e);
        }
        return (T)erg;
    }

    public static int extractIntForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractIntForTag(source, startTag, startTag);
    }

    public static int extractIntForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        try {
            return Integer.parseInt(ex.toString());
        }
        catch (NumberFormatException e) {
            throw new NonParsableException("Could not parse \"" + startTag + "\" to int.");
        }
        catch (NullPointerException e) {
            throw new NonParsableException("Could not find \"" + startTag + "\".");
        }
    }

    public static long extractLongForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractLongForTag(source, startTag, startTag);
    }

    public static long extractLongForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        try {
            return Long.parseLong(ex.toString());
        }
        catch (NumberFormatException e) {
            throw new NonParsableException("Could not parse \"" + startTag + "\" to int.");
        }
        catch (NullPointerException e) {
            throw new NonParsableException("Could not find \"" + startTag + "\".");
        }
    }

    public static double extractDoubleForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractDoubleForTag(source, startTag, startTag);
    }

    public static double extractDoubleForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        try {
            return Double.parseDouble(ex.toString());
        }
        catch (NumberFormatException e) {
            throw new NonParsableException("Could not parse \"" + startTag + "\" to double.");
        }
        catch (NullPointerException e) {
            throw new NonParsableException("Could not find \"" + startTag + "\".");
        }
    }

    public static Storable extractStorableForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractStorableForTag(source, startTag, startTag);
    }

    public static Storable extractStorableForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        Storable erg;
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        if (ex == null) {
            throw new NonParsableException("Could not find \"" + startTag + "\".");
        }
        String className = XMLParser.extractStringForTag(ex, "className");
        try {
            erg = (Storable)Class.forName(className).getConstructor(StringBuffer.class).newInstance(ex);
        }
        catch (NoSuchMethodException e) {
            throw XMLParser.getNonParsableException("You must provide a constructor " + className + "(StringBuffer).", e);
        }
        catch (Exception e) {
            throw XMLParser.getNonParsableException("problem at " + className + ": " + e.getClass().getSimpleName() + ": " + e.getCause().toString(), e);
        }
        return erg;
    }

    public static Storable extractStorableOrNullForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractStorableOrNullForTag(source, tag, tag);
    }

    public static Storable extractStorableOrNullForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        Storable erg;
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        if (ex == null) {
            throw new NonParsableException("Could not find \"" + startTag + "\".");
        }
        if (ex.toString().trim().equals("null")) {
            return null;
        }
        String className = XMLParser.extractStringForTag(ex, "className");
        try {
            erg = (Storable)Class.forName(className).getConstructor(StringBuffer.class).newInstance(ex);
        }
        catch (NoSuchMethodException e) {
            throw XMLParser.getNonParsableException("You must provide a constructor " + className + "(StringBuffer).", e);
        }
        catch (Exception e) {
            throw XMLParser.getNonParsableException("problem at " + className + ": " + e.getClass().getSimpleName() + ": " + e.getCause().toString(), e);
        }
        return erg;
    }

    private static final NonParsableException getNonParsableException(String s, Exception e) {
        NonParsableException n = new NonParsableException(s);
        n.setStackTrace(e.getStackTrace());
        return n;
    }

    public static String extractStringForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractStringForTag(source, startTag, startTag);
    }

    public static String extractStringForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        if (ex == null) {
            throw new NonParsableException("Could not find \"" + startTag + "\".");
        }
        return ex.toString();
    }

    public static boolean[] extractBooleanArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractBooleanArrayForTag(source, tag, tag);
    }

    public static boolean[] extractBooleanArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        int l = XMLParser.extractIntForTag(ex, "length");
        boolean[] b = new boolean[l];
        for (int i = 0; i < l; ++i) {
            b[i] = XMLParser.extractBooleanForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return b;
    }

    public static byte[] extractByteArrayForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractByteArrayForTag(source, startTag, startTag);
    }

    public static byte[] extractByteArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        int l = XMLParser.extractIntForTag(ex, "length");
        byte[] array = new byte[l];
        for (int i = 0; i < l; ++i) {
            array[i] = XMLParser.extractByteForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static int[] extractIntArrayForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractIntArrayForTag(source, startTag, startTag);
    }

    public static int[] extractIntArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        int l = XMLParser.extractIntForTag(ex, "length");
        int[] array = new int[l];
        for (int i = 0; i < l; ++i) {
            array[i] = XMLParser.extractIntForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static double[] extractDoubleArrayForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractDoubleArrayForTag(source, startTag, startTag);
    }

    public static double[] extractDoubleArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        int l = XMLParser.extractIntForTag(ex, "length");
        double[] array = new double[l];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLParser.extractDoubleForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static Storable[] extractStorableArrayForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractStorableArrayForTag(source, startTag, startTag);
    }

    public static Storable[] extractStorableArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        int l = XMLParser.extractIntForTag(ex, "length");
        Storable[] array = new Storable[l];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLParser.extractStorableForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static String[] extractStringArrayForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractStringArrayForTag(source, startTag, startTag);
    }

    public static String[] extractStringArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        int l = XMLParser.extractIntForTag(ex, "length");
        String[] array = new String[l];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLParser.extractStringForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static Storable[][] extractStorable2ArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractStorable2ArrayForTag(source, tag, tag);
    }

    public static Storable[][] extractStorable2ArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        int l = XMLParser.extractIntForTag(ex, "length");
        Storable[][] array = new Storable[l][];
        for (int i = 0; i < l; ++i) {
            array[i] = XMLParser.extractStorableArrayForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static Storable[][][] extractStorable3ArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractStorable3ArrayForTag(source, tag, tag);
    }

    public static Storable[][][] extractStorable3ArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        int l = XMLParser.extractIntForTag(ex, "length");
        Storable[][][] array = new Storable[l][][];
        for (int i = 0; i < l; ++i) {
            array[i] = XMLParser.extractStorable2ArrayForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static boolean[][] extractBoolean2ArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractBoolean2ArrayForTag(source, tag, tag);
    }

    public static boolean[][] extractBoolean2ArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        boolean[][] array = new boolean[XMLParser.extractIntForTag(ex, "length")][];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLParser.extractBooleanArrayForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static byte[][] extractByte2ArrayForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractByte2ArrayForTag(source, startTag, startTag);
    }

    public static byte[][] extractByte2ArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        byte[][] array = new byte[XMLParser.extractIntForTag(ex, "length")][];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XMLParser.extractByteArrayForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static int[][] extractInt2ArrayForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractInt2ArrayForTag(source, startTag, startTag);
    }

    public static int[][] extractInt2ArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        int l = XMLParser.extractIntForTag(ex, "length");
        int[][] array = new int[l][];
        for (int i = 0; i < l; ++i) {
            array[i] = XMLParser.extractIntArrayForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static double[][] extractDouble2ArrayForTag(StringBuffer source, String startTag) throws NonParsableException {
        return XMLParser.extractDouble2ArrayForTag(source, startTag, startTag);
    }

    public static double[][] extractDouble2ArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        int l = XMLParser.extractIntForTag(ex, "length");
        double[][] array = new double[l][];
        for (int i = 0; i < l; ++i) {
            array[i] = XMLParser.extractDoubleArrayForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static String[][] extractString2ArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractString2ArrayForTag(source, tag, tag);
    }

    public static String[][] extractString2ArrayForTag(StringBuffer source, String startTag, String endTag) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, startTag, endTag);
        int l = XMLParser.extractIntForTag(ex, "length");
        String[][] array = new String[l][];
        for (int i = 0; i < l; ++i) {
            array[i] = XMLParser.extractStringArrayForTag(ex, "pos val=\"" + i + "\"", "pos");
        }
        return array;
    }

    public static void addTags(StringBuffer source, String tag) {
        XMLParser.addTags(source, tag, tag);
    }

    public static void addTags(StringBuffer source, String startTag, String endTag) {
        source.insert(0, "<" + startTag + ">\n");
        source.insert(source.length(), "</" + endTag + ">\n");
    }

    public static void appendBooleanWithTags(StringBuffer source, boolean b, String tag) {
        XMLParser.appendBooleanWithTags(source, b, tag, tag);
    }

    public static void appendBooleanWithTags(StringBuffer source, boolean b, String startTag, String endTag) {
        source.append("<" + startTag + ">" + b + "</" + endTag + ">\n");
    }

    public static void appendByteWithTags(StringBuffer source, byte b, String tag) {
        XMLParser.appendIntWithTags(source, b, tag, tag);
    }

    public static void appendByteWithTags(StringBuffer source, byte b, String startTag, String endTag) {
        source.append("<" + startTag + ">" + b + "</" + endTag + ">\n");
    }

    public static <T extends Enum<T>> void appendEnumWithTags(StringBuffer source, Enum<T> e, String tag) {
        XMLParser.appendEnumWithTags(source, e, tag, tag);
    }

    public static <T extends Enum<T>> void appendEnumWithTags(StringBuffer source, Enum<T> e, String startTag, String endTag) {
        StringBuffer help = new StringBuffer(1000);
        help.append("<" + startTag + ">\n");
        XMLParser.appendStringWithTags(help, e.getClass().getName(), "enumName");
        XMLParser.appendStringWithTags(help, e.name(), "name");
        help.append("</" + endTag + ">\n");
        source.append(help);
    }

    public static void appendIntWithTags(StringBuffer source, int i, String tag) {
        XMLParser.appendIntWithTags(source, i, tag, tag);
    }

    public static void appendIntWithTags(StringBuffer source, int i, String startTag, String endTag) {
        source.append("<" + startTag + ">" + i + "</" + endTag + ">\n");
    }

    public static void appendLongWithTags(StringBuffer source, long i, String tag) {
        XMLParser.appendLongWithTags(source, i, tag, tag);
    }

    public static void appendLongWithTags(StringBuffer source, long i, String startTag, String endTag) {
        source.append("<" + startTag + ">" + i + "</" + endTag + ">\n");
    }

    public static void appendDoubleWithTags(StringBuffer source, double d, String startTag) {
        XMLParser.appendDoubleWithTags(source, d, startTag, startTag);
    }

    public static void appendDoubleWithTags(StringBuffer source, double d, String startTag, String endTag) {
        source.append("<" + startTag + ">" + d + "</" + endTag + ">\n");
    }

    public static void appendStorableWithTags(StringBuffer source, Storable s, String startTag) {
        XMLParser.appendStorableWithTags(source, s, startTag, startTag);
    }

    public static void appendStorableWithTags(StringBuffer source, Storable s, String startTag, String endTag) {
        StringBuffer help = new StringBuffer(1000);
        help.append("<" + startTag + ">\n");
        XMLParser.appendStringWithTags(help, s.getClass().getName(), "className");
        help.append(s.toXML());
        help.append("\t</" + endTag + ">\n");
        source.append(help);
    }

    public static void appendStorableOrNullWithTags(StringBuffer source, Storable s, String tag) {
        XMLParser.appendStorableOrNullWithTags(source, s, tag, tag);
    }

    public static void appendStorableOrNullWithTags(StringBuffer source, Storable s, String startTag, String endTag) {
        StringBuffer help = new StringBuffer(1000);
        help.append("<" + startTag + ">\n");
        if (s != null) {
            XMLParser.appendStringWithTags(help, s.getClass().getName(), "className");
            help.append(s.toXML());
        } else {
            help.append("null");
        }
        help.append("\t</" + endTag + ">\n");
        source.append(help);
    }

    public static void appendStringWithTags(StringBuffer source, String s, String startTag) {
        XMLParser.appendStringWithTags(source, s, startTag, startTag);
    }

    public static void appendStringWithTags(StringBuffer source, String s, String startTag, String endTag) {
        source.append("<" + startTag + ">" + s + "</" + endTag + ">\n");
    }

    protected static StringBuffer ByteArrayWithTags(byte[] b) {
        int l = b.length;
        StringBuffer source = new StringBuffer(25 + l * 30);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendIntWithTags(source, b[j], "pos val=\"" + j + "\"", "pos");
        }
        return source;
    }

    protected static StringBuffer IntArrayWithTags(int[] i) {
        int l = i.length;
        StringBuffer source = new StringBuffer(25 + l * 30);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendIntWithTags(source, i[j], "pos val=\"" + j + "\"", "pos");
        }
        return source;
    }

    protected static StringBuffer DoubleArrayWithTags(double[] d) {
        int l = d.length;
        StringBuffer source = new StringBuffer(25 + l * 40);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendDoubleWithTags(source, d[j], "pos val=\"" + j + "\"", "pos");
        }
        return source;
    }

    protected static StringBuffer BooleanArrayWithTags(boolean[] b) {
        int l = b.length;
        StringBuffer source = new StringBuffer(25 + l * 40);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendBooleanWithTags(source, b[j], "pos val=\"" + j + "\"", "pos");
        }
        return source;
    }

    protected static StringBuffer StringArrayWithTags(String[] s) {
        int l = s.length;
        StringBuffer source = new StringBuffer(25 + l * 30);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendStringWithTags(source, s[j], "pos val=\"" + j + "\"", "pos");
        }
        return source;
    }

    protected static StringBuffer StorableArrayWithTags(Storable[] s) {
        int l = s.length;
        StringBuffer source = new StringBuffer(25 + l * 1030);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendStorableWithTags(source, s[j], "pos val=\"" + j + "\"", "pos");
        }
        return source;
    }

    public static void appendBooleanArrayWithTags(StringBuffer source, boolean[] b, String tag) {
        XMLParser.appendBooleanArrayWithTags(source, b, tag, tag);
    }

    public static void appendBooleanArrayWithTags(StringBuffer source, boolean[] b, String startTag, String endTag) {
        StringBuffer help = XMLParser.BooleanArrayWithTags(b);
        XMLParser.addTags(help, startTag, endTag);
        source.append(help);
    }

    public static void appendByteArrayWithTags(StringBuffer source, byte[] b, String tag) {
        XMLParser.appendByteArrayWithTags(source, b, tag, tag);
    }

    public static void appendByteArrayWithTags(StringBuffer source, byte[] b, String startTag, String endTag) {
        StringBuffer help = XMLParser.ByteArrayWithTags(b);
        XMLParser.addTags(help, startTag, endTag);
        source.append(help);
    }

    public static void appendIntArrayWithTags(StringBuffer source, int[] i, String tag) {
        XMLParser.appendIntArrayWithTags(source, i, tag, tag);
    }

    public static void appendIntArrayWithTags(StringBuffer source, int[] i, String startTag, String endTag) {
        StringBuffer help = XMLParser.IntArrayWithTags(i);
        XMLParser.addTags(help, startTag, endTag);
        source.append(help);
    }

    public static void appendDoubleArrayWithTags(StringBuffer source, double[] d, String tag) {
        XMLParser.appendDoubleArrayWithTags(source, d, tag, tag);
    }

    public static void appendDoubleArrayWithTags(StringBuffer source, double[] d, String startTag, String endTag) {
        StringBuffer help = XMLParser.DoubleArrayWithTags(d);
        XMLParser.addTags(help, startTag, endTag);
        source.append(help);
    }

    public static void appendStorableArrayWithTags(StringBuffer source, Storable[] s, String tag) {
        XMLParser.appendStorableArrayWithTags(source, s, tag, tag);
    }

    public static void appendStorableArrayWithTags(StringBuffer source, Storable[] s, String startTag, String endTag) {
        StringBuffer help = XMLParser.StorableArrayWithTags(s);
        XMLParser.addTags(help, startTag, endTag);
        source.append(help);
    }

    public static void appendStringArrayWithTags(StringBuffer source, String[] s, String tag) {
        XMLParser.appendStringArrayWithTags(source, s, tag, tag);
    }

    public static void appendStringArrayWithTags(StringBuffer source, String[] s, String startTag, String endTag) {
        StringBuffer help = XMLParser.StringArrayWithTags(s);
        XMLParser.addTags(help, startTag, endTag);
        source.append(help);
    }

    public static void appendBoolean2ArrayWithTags(StringBuffer source, boolean[][] i, String tag) {
        XMLParser.appendBoolean2ArrayWithTags(source, i, tag, tag);
    }

    public static void appendBoolean2ArrayWithTags(StringBuffer source, boolean[][] i, String startTag, String endTag) {
        int l = i.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.BooleanArrayWithTags(i[j]);
            help2.append("\t");
            XMLParser.addTags(help2, "pos val=\"" + j + "\"", "pos");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTags(help1, startTag, endTag);
        source.append(help1);
    }

    public static void appendByte2ArrayWithTags(StringBuffer source, byte[][] i, String tag) {
        XMLParser.appendByte2ArrayWithTags(source, i, tag, tag);
    }

    public static void appendByte2ArrayWithTags(StringBuffer source, byte[][] i, String startTag, String endTag) {
        int l = i.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.ByteArrayWithTags(i[j]);
            help2.append("\t");
            XMLParser.addTags(help2, "pos val=\"" + j + "\"", "pos");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTags(help1, startTag, endTag);
        source.append(help1);
    }

    public static void appendInt2ArrayWithTags(StringBuffer source, int[][] i, String tag) {
        XMLParser.appendInt2ArrayWithTags(source, i, tag, tag);
    }

    public static void appendInt2ArrayWithTags(StringBuffer source, int[][] i, String startTag, String endTag) {
        int l = i.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.IntArrayWithTags(i[j]);
            help2.append("\t");
            XMLParser.addTags(help2, "pos val=\"" + j + "\"", "pos");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTags(help1, startTag, endTag);
        source.append(help1);
    }

    public static void appendDouble2ArrayWithTags(StringBuffer source, double[][] d, String tag) {
        XMLParser.appendDouble2ArrayWithTags(source, d, tag, tag);
    }

    public static void appendDouble2ArrayWithTags(StringBuffer source, double[][] d, String startTag, String endTag) {
        int l = d.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.DoubleArrayWithTags(d[j]);
            help2.append("\t");
            XMLParser.addTags(help2, "pos val=\"" + j + "\"", "pos");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTags(help1, startTag, endTag);
        source.append(help1);
    }

    public static void appendStorable2ArrayWithTags(StringBuffer source, Storable[][] s, String tag) {
        XMLParser.appendStorable2ArrayWithTags(source, s, tag, tag);
    }

    public static void appendStorable2ArrayWithTags(StringBuffer source, Storable[][] s, String startTag, String endTag) {
        int l = s.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.StorableArrayWithTags(s[j]);
            help2.append("\t");
            XMLParser.addTags(help2, "pos val=\"" + j + "\"", "pos");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTags(help1, startTag, endTag);
        source.append(help1);
    }

    public static void appendStorable3ArrayWithTags(StringBuffer source, Storable[][][] s, String tag) {
        XMLParser.appendStorable3ArrayWithTags(source, s, tag, tag);
    }

    public static void appendStorable3ArrayWithTags(StringBuffer source, Storable[][][] s, String startTag, String endTag) {
        int l = s.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            XMLParser.appendStorable2ArrayWithTags(help1, s[j], "pos val=\"" + j + "\"", "pos");
        }
        XMLParser.addTags(help1, startTag, endTag);
        source.append(help1);
    }

    public static void appendString2ArrayWithTags(StringBuffer source, String[][] s, String tag) {
        XMLParser.appendString2ArrayWithTags(source, s, tag, tag);
    }

    public static void appendString2ArrayWithTags(StringBuffer source, String[][] s, String startTag, String endTag) {
        int l = s.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.StringArrayWithTags(s[j]);
            help2.append("\t");
            XMLParser.addTags(help2, "pos val=\"" + j + "\"", "pos");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTags(help1, startTag, endTag);
        source.append(help1);
    }
}

