/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.models.Model;
import de.jstacs.models.discrete.DGMParameterSet;
import de.jstacs.models.discrete.inhomogeneous.DAGModel;
import de.jstacs.models.discrete.inhomogeneous.parameters.FSDAGMParameterSet;
import java.util.StringTokenizer;

public class FSDAGModel
extends DAGModel {
    private static final long serialVersionUID = 1L;
    private static final String XML_TAG = "FSDAGModel";

    public FSDAGModel(FSDAGMParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
    }

    public FSDAGModel(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public String getInstanceName() {
        return "fixed structure directed acyclic graphical model";
    }

    public byte getMaximalMarkovOrder() {
        int max = this.constraints[0].getMarginalOrder();
        for (int i = 1; i < this.length; ++i) {
            if (max >= this.constraints[i].getMarginalOrder()) continue;
            max = this.constraints[i].getMarginalOrder();
        }
        return (byte)(max - 1);
    }

    protected String getXMLTag() {
        return XML_TAG;
    }

    public void train(Sample data, double[] weights) throws Exception {
        this.estimateParameters(data, weights);
    }

    public void train(Sample data, double[] weights, int[][] graph) throws Exception {
        if (!FSDAGModel.checkAcyclic(this.length, graph)) {
            throw new IllegalArgumentException("the graph is not acyclic");
        }
        this.trainUnchecked(data, weights, graph);
    }

    public void drawParameters(Sample data, double[] weights, int[][] graph) throws Exception {
        if (graph != null) {
            if (!FSDAGModel.checkAcyclic(this.length, graph)) {
                throw new IllegalArgumentException("the graph is not acyclic");
            }
            this.params.getParameterAt(2).setValue(FSDAGMParameterSet.encode(graph));
            this.createConstraints(graph);
        }
        this.drawParameters(data, weights);
    }

    private void trainUnchecked(Sample data, double[] weights, int[][] graph) throws Exception {
        this.params.getParameterAt(2).setValue(FSDAGMParameterSet.encode(graph));
        this.createConstraints(graph);
        this.estimateParameters(data, weights);
    }

    public static void train(Model[] models, int[][] graph, double[][] weights, Sample ... data) throws Exception {
        if (!FSDAGModel.checkAcyclic(graph.length, graph)) {
            throw new IllegalArgumentException("the graph is not acyclic");
        }
        if (data.length == 1) {
            for (int i = 0; i < models.length; ++i) {
                ((FSDAGModel)models[i]).trainUnchecked(data[0], weights[i], graph);
            }
        } else {
            for (int i = 0; i < models.length; ++i) {
                ((FSDAGModel)models[i]).trainUnchecked(data[i], weights[i], graph);
            }
        }
    }

    protected void set(DGMParameterSet params, boolean trained) throws CloneNotSupportedException, NonParsableException {
        super.set(params, trained);
        int i = 0;
        StringBuffer xml = new StringBuffer((String)params.getParameterAt(2).getValue());
        int[][] graph = new int[this.length][];
        for (i = 0; i < this.length; i = (int)((byte)(i + 1))) {
            StringBuffer help = XMLParser.extractForTag(xml, "parents node=" + i, "parents");
            if (help == null) {
                graph[i] = new int[]{i};
                continue;
            }
            StringTokenizer t = new StringTokenizer(help.toString(), ",");
            graph[i] = new int[t.countTokens() + 1];
            int j = 0;
            while (t.hasMoreTokens()) {
                graph[i][j] = Integer.parseInt(t.nextToken().trim());
                if (graph[i][j] < 0 || graph[i][j] >= this.length || graph[i][j] == i) {
                    throw new IllegalArgumentException("The graph was not correct encoded. See parents from node " + i);
                }
                j = (byte)(j + 1);
            }
            graph[i][j] = i;
            if (XMLParser.extractForTag(xml, "parents node=" + i, "parents") == null) continue;
            throw new IllegalArgumentException("The graph was not correct encoded. There are at least 2 sets of parents for node " + i);
        }
        if (!FSDAGModel.checkAcyclic(this.length, graph)) {
            throw new IllegalArgumentException("the graph is not acyclic");
        }
        this.createConstraints(graph);
    }

    public String getStructure() {
        if (this.trained) {
            try {
                return super.getStructure();
            }
            catch (NotTrainedException e) {
                RuntimeException r = new RuntimeException(e.getMessage());
                throw r;
            }
        }
        StringBuffer all = new StringBuffer(500);
        for (int counter1 = 0; counter1 < this.constraints.length; ++counter1) {
            all.append(this.constraints[counter1].toString() + "\n");
        }
        return all.toString();
    }
}

