/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;

public class Parameter
implements Storable,
Cloneable {
    private double value;
    protected byte symbol;
    protected int position;
    protected int[][] context;
    protected double count;
    protected double pseudoCount;
    private boolean free;
    private int index;
    private double expValue;
    private Double z;
    private Double t;

    public Parameter clone() throws CloneNotSupportedException {
        Parameter clone = (Parameter)super.clone();
        for (int i = 0; i < this.context.length; ++i) {
            clone.context[i] = (int[])this.context[i].clone();
        }
        return clone;
    }

    public Parameter(int index, byte symbol, int position, double pseudoCount, boolean free) {
        this(index, symbol, position, new int[0][2], pseudoCount, free);
    }

    public Parameter(int index, byte symbol, int position, int[][] context, double pseudoCount, boolean free) {
        this.index = index;
        this.symbol = symbol;
        this.position = position;
        this.context = context;
        this.pseudoCount = pseudoCount;
        this.count = pseudoCount;
        this.value = 0.0;
        this.expValue = 1.0;
        this.free = free;
        this.z = null;
        this.t = null;
    }

    public Parameter(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "parameter");
        this.value = XMLParser.extractDoubleForTag(representation, "value");
        this.expValue = Math.exp(this.value);
        this.index = XMLParser.extractIntForTag(representation, "index");
        this.pseudoCount = XMLParser.extractDoubleForTag(representation, "pseudoCount");
        this.symbol = XMLParser.extractByteForTag(representation, "symbol");
        this.position = XMLParser.extractIntForTag(representation, "position");
        this.context = XMLParser.extractInt2ArrayForTag(representation, "context");
        this.count = XMLParser.extractDoubleForTag(representation, "count");
        this.free = XMLParser.extractBooleanForTag(representation, "free");
        String temp = XMLParser.extractStringForTag(representation, "z");
        this.z = temp.equals("null") ? null : Double.valueOf(Double.parseDouble(temp));
        temp = XMLParser.extractStringForTag(representation, "t");
        this.t = temp.equals("null") ? null : Double.valueOf(Double.parseDouble(temp));
    }

    public double getPseudoCount() {
        return this.pseudoCount;
    }

    public void reset() {
        this.count = this.pseudoCount;
        this.value = 0.0;
        this.expValue = 1.0;
    }

    public int getDepth() {
        return this.context.length;
    }

    public void print() {
        System.out.println(this.symbol + " c: " + this.count);
        System.out.println(this.symbol + ": " + this.value);
    }

    public double doesApplyFor(Sequence seq) {
        if (seq.discreteVal(this.position) == this.symbol) {
            for (int i = 0; i < this.context.length; ++i) {
                boolean app = false;
                for (int j = 1; j < this.context[i].length; ++j) {
                    if (seq.discreteVal(this.context[i][0]) != this.context[i][j]) continue;
                    app = true;
                }
                if (app) continue;
                return 0.0;
            }
            return 1.0;
        }
        return 0.0;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        this.expValue = Math.exp(value);
    }

    public double getExpValue() {
        return this.expValue;
    }

    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendDoubleWithTags(buf, this.value, "value");
        XMLParser.appendByteWithTags(buf, this.symbol, "symbol");
        XMLParser.appendIntWithTags(buf, this.index, "index");
        XMLParser.appendDoubleWithTags(buf, this.pseudoCount, "pseudoCount");
        XMLParser.appendIntWithTags(buf, this.position, "position");
        XMLParser.appendInt2ArrayWithTags(buf, this.context, "context");
        XMLParser.appendDoubleWithTags(buf, this.count, "count");
        XMLParser.appendBooleanWithTags(buf, this.free, "free");
        if (this.z != null) {
            XMLParser.appendDoubleWithTags(buf, this.z, "z");
        } else {
            XMLParser.appendStringWithTags(buf, null, "z");
        }
        if (this.t != null) {
            XMLParser.appendDoubleWithTags(buf, this.t, "t");
        } else {
            XMLParser.appendStringWithTags(buf, "null", "t");
        }
        XMLParser.addTags(buf, "parameter");
        return buf;
    }

    public void invalidateNormalizers() {
        this.z = null;
        this.t = null;
    }

    public double getPartialNormalizer() throws Exception {
        if (this.z == null || this.t == null) {
            throw new Exception("No valid normalizers available for parameter " + this.index + " at position " + this.position + ": z=" + this.z + ", t=" + this.t + ".");
        }
        return this.t * this.expValue * this.z;
    }

    public double getCounts() {
        return this.count;
    }

    public void addCount(double count2) {
        this.count += count2;
    }

    public boolean isFree() {
        return this.free;
    }

    public int getPosition() {
        return this.position;
    }

    public int getIndex() {
        return this.index;
    }

    void setT(Double t) {
        this.t = t;
    }

    void setZ(Double z) {
        this.z = z;
    }

    public double getZ() {
        return this.z;
    }
}

