/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.pmmMeasures;

import de.jstacs.NonParsableException;
import de.jstacs.algorithms.graphs.DAG;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.Tensor;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.Measure;

public class PMMExplainingAwayResidual
extends Measure {
    private byte order;
    private double[] ess;

    public PMMExplainingAwayResidual(StringBuffer buf) throws NonParsableException {
        buf = XMLParser.extractForTag(buf, "pmmExplainingAwayResidual");
        this.order = XMLParser.extractByteForTag(buf, "order");
        this.ess = XMLParser.extractDoubleArrayForTag(buf, "ess");
    }

    public PMMExplainingAwayResidual(byte order, double[] ess) throws Exception {
        if (order < 1 || order > 2) {
            throw new Exception("Only order 1 and 2 allowed (yet).");
        }
        this.ess = ess;
        this.order = order;
    }

    public PMMExplainingAwayResidual clone() throws CloneNotSupportedException {
        PMMExplainingAwayResidual clone = (PMMExplainingAwayResidual)super.clone();
        clone.ess = (double[])this.ess.clone();
        return clone;
    }

    public String getInstanceName() {
        return "Permuted Markov model of order " + this.order + " with explaining away residual";
    }

    public int[][] getParents(Sample fg, Sample bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        SymmetricTensor t = new SymmetricTensor(length, this.order);
        double nFg = PMMExplainingAwayResidual.sum(weightsFg) + this.ess[0];
        double nBg = PMMExplainingAwayResidual.sum(weightsBg) + this.ess[1];
        PMMExplainingAwayResidual.fillTensor((Tensor)t, PMMExplainingAwayResidual.getEAR(PMMExplainingAwayResidual.getStatistics(fg, weightsFg, length, this.ess[0]), PMMExplainingAwayResidual.getStatistics(bg, weightsBg, length, this.ess[1]), nFg, nBg));
        if (this.order == 2) {
            PMMExplainingAwayResidual.fillTensor((Tensor)t, PMMExplainingAwayResidual.getEAR(PMMExplainingAwayResidual.getStatisticsOrderTwo(fg, weightsFg, length, this.ess[0]), PMMExplainingAwayResidual.getStatisticsOrderTwo(bg, weightsBg, length, this.ess[1]), nFg, nBg));
        }
        int[] o = DAG.computeMaximalHP(t);
        return PMMExplainingAwayResidual.toParents(o, this.order);
    }

    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendByteWithTags(buf, this.order, "order");
        XMLParser.appendDoubleArrayWithTags(buf, this.ess, "ess");
        XMLParser.addTags(buf, "pmmExplainingAwayResidual");
        return buf;
    }
}

