/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.pmmMeasures;

import de.jstacs.NonParsableException;
import de.jstacs.algorithms.graphs.DAG;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.Tensor;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.Measure;

public class PMMMutualInformation
extends Measure {
    private int clazz;
    private byte order;
    private double[] ess;
    public static final int FG = 0;
    public static final int BG = 1;
    public static final int BOTH = 2;

    public PMMMutualInformation(byte order, int clazz, double[] ess) throws Exception {
        if (order < 1 || order > 2) {
            throw new Exception("Only order 1 and 2 allowed (yet).");
        }
        this.order = order;
        this.ess = ess;
        if (clazz != 0 && clazz != 1 && clazz != 2) {
            throw new Exception("Value of clazz not allowed.");
        }
        this.clazz = clazz;
    }

    public PMMMutualInformation(StringBuffer buf) throws NonParsableException {
        buf = XMLParser.extractForTag(buf, "pmmMutualInformation");
        this.order = XMLParser.extractByteForTag(buf, "order");
        this.clazz = XMLParser.extractIntForTag(buf, "clazz");
        this.ess = XMLParser.extractDoubleArrayForTag(buf, "ess");
    }

    public PMMMutualInformation clone() throws CloneNotSupportedException {
        PMMMutualInformation clone = (PMMMutualInformation)super.clone();
        clone.ess = (double[])this.ess.clone();
        return clone;
    }

    public String getInstanceName() {
        String str = "Permuted Markov model of order " + this.order + " with mutual information of";
        if (this.clazz == 0) {
            return str + " foreground";
        }
        if (this.clazz == 1) {
            return str + " background";
        }
        return str + " foreground and background";
    }

    public int[][] getParents(Sample fg, Sample bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        Sample data = null;
        double[] weights = null;
        double ess2 = 0.0;
        if (this.clazz == 0) {
            data = fg;
            weights = weightsFg;
            ess2 = this.ess[0];
        } else if (this.clazz == 1) {
            data = bg;
            weights = weightsBg;
            ess2 = this.ess[1];
        } else {
            data = Sample.union(fg, bg);
            weights = PMMMutualInformation.union(new double[][]{weightsFg, weightsBg});
            ess2 = this.ess[0] + this.ess[1];
        }
        SymmetricTensor t = new SymmetricTensor(length, this.order);
        PMMMutualInformation.fillTensor((Tensor)t, PMMMutualInformation.getMI(PMMMutualInformation.getStatistics(data, weights, length, ess2), PMMMutualInformation.sum(weights) + ess2));
        if (this.order == 2) {
            PMMMutualInformation.fillTensor((Tensor)t, PMMMutualInformation.getMI(PMMMutualInformation.getStatisticsOrderTwo(data, weights, length, ess2), PMMMutualInformation.sum(weights) + ess2));
        }
        int[] o = DAG.computeMaximalHP(t);
        return PMMMutualInformation.toParents(o, this.order);
    }

    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendByteWithTags(buf, this.order, "order");
        XMLParser.appendIntWithTags(buf, this.clazz, "clazz");
        XMLParser.appendDoubleArrayWithTags(buf, this.ess, "ess");
        XMLParser.addTags(buf, "pmmMutualInformation");
        return buf;
    }
}

