/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.utils.DefaultProgressUpdater;
import de.jstacs.utils.Time;

public class TimeLimitedProgressUpdater
extends DefaultProgressUpdater {
    private long seconds;
    private boolean start;
    private Time t;

    public TimeLimitedProgressUpdater(Time t, int sec, int min, int hours, int days) throws IllegalArgumentException {
        if (sec < 0 || min < 0 || hours < 0 || days < 0) {
            throw new IllegalArgumentException("The values of sec, min, hours and days have to be non-negative.");
        }
        this.seconds = sec + 60 * min + 3600 * hours + 86400 * days;
        this.t = t;
        this.start = false;
    }

    public void setValue(int value) {
        if (!this.start) {
            this.t.reset();
            this.start = true;
        }
        super.setValue(value);
        if (value == this.max) {
            this.start = false;
        }
    }

    public boolean isCancelled() {
        return this.t.getElapsedTime() >= (double)this.seconds;
    }

    public String toString() {
        long e = this.seconds;
        String erg = e % 60L < 10L ? ":0" + e % 60L : ":" + e % 60L;
        erg = (e /= 60L) % 60L < 10L ? ":0" + e % 60L + erg : ":" + e % 60L + erg;
        erg = (e /= 60L) % 24L + erg;
        if (e % 24L < 10L) {
            erg = "0" + erg;
        }
        return "Timer: " + (e /= 24L) + " days and " + erg;
    }
}

