/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx;

import de.jstacs.fx.HelpViewer;
import de.jstacs.fx.LoadSaveDialogs;
import de.jstacs.fx.Messages;
import de.jstacs.fx.SplashScreen;
import de.jstacs.fx.TaskViewer;
import de.jstacs.fx.renderers.parameters.ParameterSetRenderer;
import de.jstacs.fx.repository.ResultRepository;
import de.jstacs.fx.repository.ResultRepositoryRenderer;
import de.jstacs.io.FileManager;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSetResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.Compression;
import de.jstacs.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.prefs.Preferences;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;

public class Application {
    private static Preferences prefs = Preferences.userNodeForPackage(Application.class);
    public static Window mainWindow;
    private ObservableList<Task<ResultSetResult>> enqueuedJobs;
    private HashMap<Task<ResultSetResult>, Pair<String, Date>> nameMap;
    private String title;
    private boolean showStackTraceInProtocol;
    private JstacsTool[] tools;
    private SplitPane parameterMain;
    private ProgressBar progressBar;
    private Label enqueued;
    private Messages messageOverlay;
    private FXProtocol protocol;
    private TaskViewer tasks;
    private HashMap<String, TitledPane> paneMap;

    public Application(String title, JstacsTool ... tools) {
        this(title, true, tools);
    }

    /*
     * Exception decompiling
     */
    public Application(String title, boolean showStackTraceInProtocol, JstacsTool ... tools) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Pane getToolParameters(final JstacsTool tool, final ParameterSet parameters2) {
        ParameterSetRenderer renderer = new ParameterSetRenderer();
        final Label error = new Label();
        error.setWrapText(true);
        error.getStyleClass().add((Object)"error");
        Button b = new Button("Run " + tool.getToolName() + "...");
        b.setDisable(!parameters2.hasDefaultOrIsSet());
        Pane p = renderer.render(parameters2, new ToolReady(b, parameters2));
        p.getChildren().add((Object)error);
        b.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                ParameterSet parameters;
                boolean ready = parameters2.hasDefaultOrIsSet();
                error.setText(parameters2.getErrorMessage());
                if (!ready) {
                    return;
                }
                try {
                    parameters = parameters2.clone();
                }
                catch (CloneNotSupportedException e1) {
                    Application.this.messageOverlay.displayMessage("Internal error copying parameter values.", Messages.Level.WARNING);
                    return;
                }
                Application.this.progressBar.setVisible(true);
                Task<ResultSetResult> task = new Task<ResultSetResult>(){

                    protected ResultSetResult call() throws Exception {
                        ProgressUpdater progress = new ProgressUpdater(){

                            public void setCurrent(double d) {
                                super.setCurrent(d);
                                this.updateProgress(this.getPercentage(), 1.0);
                            }
                        };
                        Application.this.protocol.appendHeading("Starting " + tool.getToolName() + "...\n\n");
                        try {
                            ToolResult res = tool.run(parameters, (Protocol)Application.this.protocol, progress, Runtime.getRuntime().availableProcessors());
                            Application.this.protocol.append("\n...finished.\n");
                            Application.this.protocol.append("\n######################################################\n\n\n");
                            return res;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            Application.this.protocol.appendHeading("Tool " + tool.getToolName() + " failed.\nError message:\n");
                            Application.this.protocol.appendWarning(e.getMessage() + "\n\n");
                            if (Application.this.showStackTraceInProtocol) {
                                Application.this.protocol.appendWarning(sw.toString() + "\n");
                            }
                            Application.this.protocol.append("\n######################################################\n\n\n");
                            throw e;
                        }
                    }
                };
                task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>((Task)task){
                    final /* synthetic */ Task val$task;
                    {
                        this.val$task = task;
                    }

                    public void handle(WorkerStateEvent arg0) {
                        Application.this.messageOverlay.displayMessage(tool.getToolName() + " finished successfully", Messages.Level.SUCCESS);
                        Application.this.enqueuedJobs.remove((Object)arg0.getSource());
                        Application.this.nameMap.remove(arg0.getSource());
                        ResultSetResult toolResults = (ResultSetResult)this.val$task.getValue();
                        ResultRepository.getInstance().add((Result)toolResults);
                    }
                });
                EventHandler<WorkerStateEvent> eh = new EventHandler<WorkerStateEvent>(){

                    public void handle(WorkerStateEvent arg0) {
                        Application.this.enqueuedJobs.remove((Object)arg0.getSource());
                        Application.this.nameMap.remove(arg0.getSource());
                        if (arg0.getEventType().equals(WorkerStateEvent.WORKER_STATE_FAILED)) {
                            String msg = "";
                            Throwable exception = arg0.getSource().getException();
                            if (exception != null) {
                                msg = exception.getMessage();
                                if (msg.length() > 80) {
                                    msg = msg.substring(0, Math.max(80, msg.indexOf(" ", 80))) + "...";
                                }
                                msg = msg + "\n";
                            }
                            Application.this.messageOverlay.displayMessage(tool.getToolName() + " failed:\n" + msg + "See protocol for details", Messages.Level.WARNING);
                        } else if (arg0.getEventType().equals(WorkerStateEvent.WORKER_STATE_CANCELLED)) {
                            Application.this.messageOverlay.displayMessage(tool.getToolName() + " canceled; see protocol for details", Messages.Level.INFO);
                        } else {
                            Application.this.messageOverlay.displayMessage(tool.getToolName() + " stopped", Messages.Level.INFO);
                        }
                    }
                };
                task.setOnCancelled((EventHandler)eh);
                task.setOnFailed((EventHandler)eh);
                task.setOnRunning((EventHandler)new EventHandler<WorkerStateEvent>(){

                    public void handle(WorkerStateEvent arg0) {
                        Application.this.progressBar.progressProperty().bind((ObservableValue)arg0.getSource().progressProperty());
                    }
                });
                Application.this.nameMap.put(task, new Pair((Object)tool.getToolName(), (Object)new Date(System.currentTimeMillis())));
                Application.this.enqueuedJobs.add(Application.this.enqueuedJobs.size(), (Object)task);
            }
        });
        p.getChildren().add((Object)b);
        return p;
    }

    public void setParametersFromCopy(ToolResult res) {
        String tn = res.getToolName();
        TitledPane target = this.paneMap.get(tn);
        for (int i = 0; i < this.tools.length; ++i) {
            String name = this.tools[i].getToolName();
            if (!name.equals(tn)) continue;
            ParameterSet tps = this.tools[i].getToolParameters();
            res.setFromStoredParameters(tps);
            Pane content = this.getToolParameters(this.tools[i], tps);
            target.setContent((Node)content);
            target.setExpanded(true);
            return;
        }
    }

    private void addToolParameters(ScrollPane pane) {
        VBox acc = new VBox();
        final TitledPane[] titleds = new TitledPane[this.tools.length];
        for (int i = 0; i < this.tools.length; ++i) {
            final int idx = i;
            String title = this.tools[i].getToolName();
            Pane content = this.getToolParameters(this.tools[i], this.tools[i].getToolParameters());
            final TitledPane titled = new TitledPane();
            titled.setContent((Node)content);
            final HBox head = new HBox();
            head.setAlignment(Pos.CENTER);
            head.getChildren().add((Object)new Label(title));
            Region reg = new Region();
            HBox.setHgrow((Node)reg, (Priority)Priority.ALWAYS);
            head.getChildren().add((Object)reg);
            Button help = new Button("?");
            help.setId("helpbutton");
            help.setPrefSize(20.0, 20.0);
            help.setMinSize(20.0, 20.0);
            help.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    new HelpViewer(Application.this.tools[idx]);
                }
            });
            head.getChildren().add((Object)help);
            pane.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                    head.setMinWidth(arg2.doubleValue() - 50.0);
                    head.setMaxWidth(arg2.doubleValue() - 50.0);
                }
            });
            titled.setGraphic((Node)head);
            this.paneMap.put(title, titled);
            titled.setExpanded(this.tools.length == 1);
            acc.getChildren().add((Object)titled);
            titleds[i] = titled;
            titled.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                    if (arg2.booleanValue()) {
                        for (int j = 0; j < titleds.length; ++j) {
                            if (titleds[j] == titled) continue;
                            titleds[j].setExpanded(false);
                        }
                    }
                }
            });
        }
        pane.setContent((Node)acc);
    }

    private HBox createStatusBar() {
        HBox statusBar = new HBox(20.0);
        statusBar.setPrefHeight(30.0);
        statusBar.setAlignment(Pos.CENTER);
        Region region = new Region();
        region.setMinWidth(10.0);
        statusBar.getChildren().add((Object)region);
        this.progressBar = new ProgressBar();
        this.progressBar.setVisible(false);
        this.progressBar.setPrefWidth(200.0);
        statusBar.getChildren().add((Object)this.progressBar);
        this.enqueued = new Label("(0 Jobs pending)");
        statusBar.getChildren().add((Object)this.enqueued);
        this.enqueuedJobs.addListener((ListChangeListener)new ListChangeListener<Task<ResultSetResult>>(){

            public void onChanged(ListChangeListener.Change<? extends Task<ResultSetResult>> arg0) {
                int num = Math.max(0, arg0.getList().size() - 1);
                String job = num == 1 ? "job" : "jobs";
                Application.this.enqueued.setText("(" + num + " " + job + " pending)");
                if (arg0.getList().size() > 0 && ((Task)arg0.getList().get(0)).getState() == Worker.State.READY) {
                    Thread thread = new Thread((Runnable)arg0.getList().get(0));
                    thread.setDaemon(true);
                    thread.start();
                    Application.this.messageOverlay.displayMessage((String)((Pair)Application.this.nameMap.get(arg0.getList().get(0))).getFirstElement() + " started", Messages.Level.INFO);
                } else if (arg0.getList().size() == 0) {
                    Application.this.progressBar.setVisible(false);
                }
            }
        });
        Button b = new Button("Tasklist...");
        statusBar.getChildren().add((Object)b);
        b.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                Application.this.tasks.show();
            }
        });
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        statusBar.getChildren().add((Object)spacer);
        CheckBox check = new CheckBox("Autosave workspace");
        check.setAllowIndeterminate(false);
        check.selectedProperty().bindBidirectional((Property)ResultRepository.autosave);
        check.setSelected(prefs.getBoolean("autosave", false));
        check.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                prefs.putBoolean("autosave", arg2);
                ResultRepository.getInstance().autostore();
            }
        });
        Button save = new Button("Save workspace...");
        save.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                File f = LoadSaveDialogs.showSaveDialog(mainWindow, "workspace", "JST", "*.jst");
                if (f == null) {
                    return;
                }
                StringBuffer sb = ResultRepository.getInstance().storeResultsToXML();
                try {
                    FileManager.writeFile((File)f, (CharSequence)Compression.zip((String)sb.toString()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Application.this.messageOverlay.displayMessage("Storing failed", Messages.Level.WARNING);
                }
            }
        });
        Button load = new Button("Load workspace...");
        load.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                File f = LoadSaveDialogs.showLoadDialog(mainWindow, "JST", "*.jst");
                if (f == null) {
                    return;
                }
                try {
                    StringBuffer sb = new StringBuffer(Compression.unzip((String)FileManager.readFile((File)f).toString()));
                    ResultRepository.getInstance().restoreResultsFromXML(sb);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Application.this.messageOverlay.displayMessage("Loading failed", Messages.Level.WARNING);
                }
            }
        });
        statusBar.getChildren().addAll((Object[])new Node[]{check, save, load});
        region = new Region();
        region.setMinWidth(10.0);
        statusBar.getChildren().add((Object)region);
        return statusBar;
    }

    public void startWithSplash(final Stage primaryStage, String message) {
        final Application app = this;
        Pane splashContent = SplashScreen.prepare(message);
        SplashScreen splash = new SplashScreen(splashContent);
        primaryStage.initStyle(StageStyle.UNDECORATED);
        primaryStage.setScene((Scene)splash);
        primaryStage.show();
        final Stage mainStage = new Stage(StageStyle.DECORATED);
        Task<Pane> task = new Task<Pane>(){

            protected Pane call() throws Exception {
                try {
                    Pane pane = app.prepare(mainStage);
                    return pane;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        };
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>((Task)task, app, mainStage){
            final /* synthetic */ Task val$task;
            final /* synthetic */ Application val$app;
            final /* synthetic */ Stage val$mainStage;
            {
                this.val$task = task;
                this.val$app = application;
                this.val$mainStage = stage2;
            }

            public void handle(WorkerStateEvent arg0) {
                primaryStage.close();
                Pane pane = (Pane)this.val$task.getValue();
                this.val$app.showApplication(pane, this.val$mainStage);
            }
        });
        new Thread((Runnable)task).start();
    }

    private Transition getTransition(Tab tab) {
        Label node = (Label)tab.getGraphic();
        MyTransition ft = new MyTransition(node, tab);
        ft.setCycleCount(2);
        ft.setAutoReverse(true);
        return ft;
    }

    private Node getTabLabel(String title) {
        Label lab2 = new Label(title);
        lab2.setFont(Font.font((String)lab2.getFont().getName(), (FontWeight)FontWeight.EXTRA_BOLD, (double)lab2.getFont().getSize()));
        return lab2;
    }

    private Pane prepare(final Stage primaryStage) {
        BorderPane border = new BorderPane();
        HBox statusBar = this.createStatusBar();
        border.setBottom((Node)statusBar);
        this.parameterMain = new SplitPane();
        ScrollPane parameterScroller = new ScrollPane();
        this.addToolParameters(parameterScroller);
        parameterScroller.setFitToWidth(true);
        this.parameterMain.setOrientation(Orientation.HORIZONTAL);
        SplitPane resultViewer = new SplitPane();
        resultViewer.setOrientation(Orientation.VERTICAL);
        BorderPane viewerPane = new BorderPane();
        ResultRepositoryRenderer rrr = new ResultRepositoryRenderer(viewerPane, this);
        Control c = rrr.getControl();
        TabPane tabbed = new TabPane();
        tabbed.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        Tab reposTab = new Tab();
        Node reposLab = this.getTabLabel("Data");
        reposTab.setGraphic(reposLab);
        reposTab.setContent((Node)c);
        final Transition reposTrans = this.getTransition(reposTab);
        rrr.addListener(new ListChangeListener(){

            public void onChanged(ListChangeListener.Change arg0) {
                reposTrans.play();
            }
        });
        Tab protoTab = new Tab();
        Node protoLab = this.getTabLabel("Protocol");
        protoTab.setGraphic(protoLab);
        this.protocol = new FXProtocol();
        ScrollPane protSP = new ScrollPane((Node)this.protocol.getTextFlow());
        protSP.setFitToWidth(true);
        protSP.setId("protpane");
        HBox hb = new HBox();
        hb.setPrefHeight(30.0);
        hb.setAlignment(Pos.CENTER);
        Button saveProt = new Button("Save protocol...");
        saveProt.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                File f = LoadSaveDialogs.showSaveDialog((Window)primaryStage, "protocol", "TXT", "*.txt");
                if (f == null) {
                    return;
                }
                try {
                    FileManager.writeFile((File)f, (CharSequence)Application.this.protocol.toString());
                }
                catch (IOException e) {
                    Application.this.messageOverlay.displayMessage("Protocol could not be saved.", Messages.Level.WARNING);
                }
            }
        });
        hb.getChildren().add((Object)saveProt);
        Region spacer = new Region();
        spacer.setMinWidth(100.0);
        hb.getChildren().add((Object)spacer);
        Button eraseProt = new Button("Erase protocol...");
        eraseProt.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setWidth(300.0);
                alert.setTitle("Erase procotol?");
                alert.setHeaderText("Do you really want to erase the protocol.");
                alert.setContentText("This cannot be undone, so you might want to save your protocol to disk beforehand.");
                ButtonType cancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
                ButtonType ok = new ButtonType("Erase", ButtonBar.ButtonData.OK_DONE);
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{cancel, ok});
                Optional result = alert.showAndWait();
                if (result.get() == ok) {
                    Application.this.protocol.erase();
                    Application.this.messageOverlay.displayMessage("Protocol erased.", Messages.Level.INFO);
                }
            }
        });
        hb.getChildren().add((Object)eraseProt);
        BorderPane protBP = new BorderPane();
        protBP.setCenter((Node)protSP);
        protBP.setTop((Node)hb);
        protoTab.setContent((Node)protBP);
        final Transition protoTrans = this.getTransition(protoTab);
        this.protocol.getTextFlow().getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> arg0) {
                protoTrans.play();
            }
        });
        tabbed.getTabs().addAll((Object[])new Tab[]{reposTab, protoTab});
        resultViewer.getItems().addAll((Object[])new Node[]{viewerPane, tabbed});
        resultViewer.setDividerPositions(new double[]{prefs.getDouble("resultViewerDivider", 0.8)});
        ((SplitPane.Divider)resultViewer.getDividers().get(0)).positionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                prefs.putDouble("resultViewerDivider", arg2.doubleValue());
            }
        });
        this.parameterMain.getItems().addAll((Object[])new Node[]{parameterScroller, resultViewer});
        this.parameterMain.setDividerPositions(new double[]{prefs.getDouble("parameterMainDivider", 0.3)});
        ((SplitPane.Divider)this.parameterMain.getDividers().get(0)).positionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                prefs.putDouble("parameterMainDivider", arg2.doubleValue());
            }
        });
        border.setCenter((Node)this.parameterMain);
        this.messageOverlay = new Messages();
        Pane messPane = this.messageOverlay.getMessagePane();
        StackPane p = new StackPane();
        p.getChildren().addAll((Object[])new Node[]{border, messPane});
        return p;
    }

    private void showApplication(Pane border, Stage primaryStage) {
        Scene scene = new Scene((Parent)border, prefs.getDouble("width", 1000.0), prefs.getDouble("height", 700.0));
        scene.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number oldval, Number newval) {
                prefs.putDouble("width", newval.doubleValue());
            }
        });
        scene.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number oldval, Number newval) {
                prefs.putDouble("height", newval.doubleValue());
            }
        });
        primaryStage.setScene(scene);
        primaryStage.getScene().getStylesheets().add((Object)"de/jstacs/fx/application.css");
        primaryStage.setTitle(this.title);
        mainWindow = primaryStage;
        primaryStage.show();
    }

    public void startApplication(Stage primaryStage) throws Exception {
        Pane border = this.prepare(primaryStage);
        this.showApplication(border, primaryStage);
    }

    private class MyTransition
    extends Transition {
        private Label lab2;
        private Tab tab;

        public MyTransition(final Label lab2, final Tab tab) {
            this.lab2 = lab2;
            this.tab = tab;
            this.tab.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

                public void handle(Event arg0) {
                    if (tab.isSelected()) {
                        lab2.setStyle("-fx-text-fill: black");
                    }
                }
            });
            this.setCycleDuration(Duration.millis((double)1000.0));
        }

        protected void interpolate(double arg0) {
            if (!this.tab.isSelected() && this.lab2.getOpacity() < arg0) {
                this.lab2.setStyle("-fx-text-fill: darkblue");
            }
            this.lab2.setOpacity(1.0 - arg0 * 0.7);
        }
    }

    public static class ToolReady {
        private Button runButton;
        private ParameterSet toolParameters;
        private LinkedList<Pair<Parameter, Label>> errorList;

        public ToolReady(Button runButton, ParameterSet toolParameters) {
            this.runButton = runButton;
            this.toolParameters = toolParameters;
            this.errorList = new LinkedList();
        }

        public void addErrorLabel(Parameter par, Label error) {
            this.errorList.add((Pair<Parameter, Label>)new Pair((Object)par, (Object)error));
        }

        public void testReady() {
            this.runButton.setDisable(!this.toolParameters.hasDefaultOrIsSet());
            for (int i = 0; i < this.errorList.size(); ++i) {
                Pair<Parameter, Label> pair = this.errorList.get(i);
                ((Label)pair.getSecondElement()).setText(((Parameter)pair.getFirstElement()).getErrorMessage());
            }
        }
    }

    public class FXProtocol
    implements Protocol {
        private TextFlow flow = new TextFlow();
        private StringBuffer log;

        public FXProtocol() {
            this.flow.setId("protocol");
            this.log = new StringBuffer();
        }

        public TextFlow getTextFlow() {
            return this.flow;
        }

        public synchronized void erase() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXProtocol.this.flow.getChildren().clear();
                    FXProtocol.this.log = new StringBuffer();
                }
            });
        }

        public synchronized void append(final String str) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXProtocol.this.flow.getChildren().add((Object)new Text(str));
                    FXProtocol.this.log.append(str);
                }
            });
        }

        public synchronized void appendHeading(final String heading) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Text text = new Text(heading);
                    text.setId("heading");
                    FXProtocol.this.flow.getChildren().add((Object)text);
                    FXProtocol.this.log.append("* " + heading);
                }
            });
        }

        public synchronized void appendWarning(final String warning) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Text text = new Text(warning);
                    text.setId("warning");
                    FXProtocol.this.flow.getChildren().add((Object)text);
                    FXProtocol.this.log.append(warning);
                }
            });
        }

        public void appendThrowable(final Throwable th) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    StringWriter str = new StringWriter();
                    th.printStackTrace(new PrintWriter(str));
                    String strstr = str.toString();
                    if (strstr.length() > 5000) {
                        strstr = strstr.substring(0, 5000) + "\n";
                    }
                    Text text = new Text(strstr);
                    text.setId("warning");
                    FXProtocol.this.flow.getChildren().add((Object)text);
                    FXProtocol.this.log.append(strstr);
                }
            });
        }

        public void appendVerbatim(String verbatim) {
            this.append(verbatim);
        }

        public String toString() {
            return this.log.toString();
        }

        public void flush() throws IOException {
        }
    }
}

