/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx;

import de.jstacs.tools.JstacsTool;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;

public class HelpViewer
extends Stage {
    public HelpViewer(JstacsTool tool) {
        this.setTitle("Help for " + tool.getToolName());
        String content = tool.getHelpText();
        content = HelpViewer.parse(content);
        final WebView view = new WebView();
        view.getEngine().loadContent(content);
        view.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> arg0, Worker.State arg1, Worker.State arg2) {
                if (arg2 == Worker.State.SUCCEEDED) {
                    Document doc = view.getEngine().getDocument();
                    NodeList list = doc.getElementsByTagName("a");
                    for (int i = 0; i < list.getLength(); ++i) {
                        EventTarget target = (EventTarget)((Object)list.item(i));
                        target.addEventListener("click", new EventListener(){

                            @Override
                            public void handleEvent(Event evt) {
                                EventTarget target = evt.getCurrentTarget();
                                HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)target);
                                String href = anchorElement.getHref();
                                Desktop d = Desktop.getDesktop();
                                try {
                                    d.browse(new URI(href));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                catch (URISyntaxException e) {
                                    e.printStackTrace();
                                }
                                evt.preventDefault();
                            }
                        }, false);
                    }
                }
            }
        });
        BorderPane pane = new BorderPane();
        pane.setCenter((Node)view);
        Scene scene = new Scene((Parent)pane, 500.0, 400.0);
        this.setScene(scene);
        this.show();
    }

    private static String parse(String restruct) {
        int i;
        String[] lines = restruct.split("\n");
        Pattern bold = Pattern.compile("\\*\\*(.+?)\\*\\*");
        Pattern italics = Pattern.compile("\\*(.+?)\\*");
        Pattern tt = Pattern.compile("\\`\\`(.+?)\\`\\`");
        Pattern amp = Pattern.compile("\"");
        Pattern link = Pattern.compile("^\\.\\.\\s+\\_(.*?)\\s*\\:\\s*(.*)$");
        HashMap<Pattern, String> linkTargets = new HashMap<Pattern, String>();
        for (i = 0; i < lines.length; ++i) {
            Matcher m = bold.matcher(lines[i]);
            lines[i] = m.replaceAll("<b>$1</b>");
            m = italics.matcher(lines[i]);
            lines[i] = m.replaceAll("<i>$1</i>");
            m = tt.matcher(lines[i]);
            lines[i] = m.replaceAll("<kbd>$1</kbd>");
            m = amp.matcher(lines[i]);
            lines[i] = m.replaceAll("&quot;");
            m = link.matcher(lines[i]);
            if (m.matches()) {
                String key = m.group(1);
                String target = m.group(2);
                linkTargets.put(Pattern.compile("\\`?(" + key + ")\\`?\\_"), target);
                lines[i] = "";
                continue;
            }
            lines[i] = lines[i] + "<br>";
        }
        for (i = 0; i < lines.length; ++i) {
            Set pats = linkTargets.keySet();
            for (Pattern pat : pats) {
                Matcher m = pat.matcher(lines[i]);
                lines[i] = m.replaceAll("<a href=\"" + (String)linkTargets.get(pat) + "\">$1</a>");
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<div style=\"font-family:sans-serif;\">");
        for (int i2 = 0; i2 < lines.length; ++i2) {
            sb.append(lines[i2]);
            sb.append("\n");
        }
        sb.append("</div>");
        return sb.toString();
    }
}

