/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.renderers.parameters;

import de.jstacs.DataType;
import de.jstacs.fx.Application;
import de.jstacs.fx.renderers.parameters.AbstractParameterRenderer;
import de.jstacs.fx.renderers.parameters.ParameterRendererLibrary;
import de.jstacs.parameters.SimpleParameter;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;

public class SimpleParameterRenderer
extends AbstractParameterRenderer<SimpleParameter> {
    public static void register() {
        ParameterRendererLibrary.register(SimpleParameter.class, new SimpleParameterRenderer());
    }

    private SimpleParameterRenderer() {
    }

    @Override
    protected void addInputs(final SimpleParameter parameter, Pane parent, Label name, Node comment, final Label error, final Application.ToolReady ready) {
        if (parameter.getDatatype() == DataType.BOOLEAN) {
            final CheckBox cb = new CheckBox();
            cb.setIndeterminate(false);
            cb.setSelected(((Boolean)parameter.getValue()).booleanValue());
            parent.getChildren().add((Object)cb);
            cb.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(ActionEvent event) {
                    try {
                        parameter.setValue((Object)cb.isSelected());
                    }
                    catch (SimpleParameter.IllegalValueException e) {
                        try {
                            parameter.setValue(null);
                        }
                        catch (SimpleParameter.IllegalValueException e1) {
                            e1.printStackTrace();
                        }
                    }
                    finally {
                        ready.testReady();
                        error.setText(parameter.getErrorMessage());
                    }
                }
            });
        } else {
            final TextField input = new TextField();
            if (parameter.hasDefaultOrIsSet()) {
                input.setText(parameter.getValue().toString());
            }
            parent.getChildren().add((Object)input);
            ChangeListener<Boolean> cl = new ChangeListener<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    try {
                        parameter.setValue((Object)input.getText());
                        input.setText(parameter.getValue().toString());
                    }
                    catch (SimpleParameter.IllegalValueException illegalValueException) {
                    }
                    finally {
                        error.setText(parameter.getErrorMessage());
                        ready.testReady();
                    }
                }
            };
            input.focusedProperty().addListener((ChangeListener)cl);
            ChangeListener<String> cl2 = new ChangeListener<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    try {
                        parameter.setValue((Object)input.getText());
                    }
                    catch (SimpleParameter.IllegalValueException illegalValueException) {
                    }
                    finally {
                        error.setText(parameter.getErrorMessage());
                        ready.testReady();
                    }
                }
            };
            input.textProperty().addListener((ChangeListener)cl2);
            input.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    try {
                        parameter.setValue((Object)input.getText());
                        input.setText(parameter.getValue().toString());
                    }
                    catch (SimpleParameter.IllegalValueException illegalValueException) {
                    }
                    finally {
                        ready.testReady();
                        error.setText(parameter.getErrorMessage());
                    }
                }
            });
        }
    }
}

