/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.renderers.results;

import de.jstacs.fx.renderers.results.ResultRenderer;
import de.jstacs.fx.renderers.results.ResultRendererLibrary;
import de.jstacs.results.ListResult;
import de.jstacs.results.ResultSet;
import java.util.LinkedList;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.Pane;
import javafx.util.Callback;

public class ListResultRenderer
implements ResultRenderer<ListResult> {
    public static void register() {
        ResultRendererLibrary.register(ListResult.class, new ListResultRenderer());
    }

    private ListResultRenderer() {
    }

    @Override
    public Node render(ListResult result, Pane parent) {
        ResultSet[] ress = result.getValue();
        LinkedList<Object[]> list = new LinkedList<Object[]>();
        String[] colNames = null;
        for (int i = 0; i < ress.length; ++i) {
            if (colNames == null) {
                colNames = new String[ress[i].getNumberOfResults()];
                for (int j = 0; j < ress[i].getNumberOfResults(); ++j) {
                    colNames[j] = ress[i].getResultAt(j).getName();
                }
            }
            Object[] vals = new Object[ress[i].getNumberOfResults()];
            for (int j = 0; j < ress[i].getNumberOfResults(); ++j) {
                Object val = ress[i].getResultAt(j).getValue();
                vals[j] = val instanceof Number ? (Number)val : val.toString();
            }
            list.add(vals);
        }
        if (list.size() > 0) {
            Object[] fico = (Object[])list.getFirst();
            TableColumn countCol = new TableColumn("#");
            countCol.setSortable(false);
            Object[] cols = new TableColumn[colNames.length];
            cols[0] = countCol;
            for (int i = 0; i < colNames.length; ++i) {
                final int col = i;
                if (fico[col] instanceof Number) {
                    TableColumn numCol = new TableColumn(colNames[i]);
                    numCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Object[], Number>, ObservableValue<Number>>(){

                        public ObservableValue<Number> call(TableColumn.CellDataFeatures<Object[], Number> arg0) {
                            return new ReadOnlyObjectWrapper((Object)((Number)((Object[])arg0.getValue())[col]));
                        }
                    });
                    cols[i] = numCol;
                    continue;
                }
                TableColumn strCol = new TableColumn(colNames[i]);
                strCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Object[], String>, ObservableValue<String>>(){

                    public ObservableValue<String> call(TableColumn.CellDataFeatures<Object[], String> arg0) {
                        return new ReadOnlyStringWrapper(((Object[])arg0.getValue())[col].toString());
                    }
                });
                cols[i] = strCol;
            }
            TableView tv = new TableView();
            tv.getColumns().add((Object)countCol);
            tv.getColumns().addAll(cols);
            tv.setItems(FXCollections.observableArrayList((Object[])list.toArray((T[])new Object[0][0])));
            countCol.setCellValueFactory(column -> new ReadOnlyObjectWrapper((Object)(tv.getItems().indexOf(column.getValue()) + 1)));
            return tv;
        }
        return null;
    }
}

