/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.renderers.results;

import de.jstacs.fx.renderers.results.DataSetResultRenderer;
import de.jstacs.fx.renderers.results.ListResultRenderer;
import de.jstacs.fx.renderers.results.PlotGeneratorResultRenderer;
import de.jstacs.fx.renderers.results.ResultRenderer;
import de.jstacs.fx.renderers.results.ResultSetResultRenderer;
import de.jstacs.fx.renderers.results.TextResultRenderer;
import de.jstacs.results.Result;
import java.util.HashMap;
import java.util.Set;

public class ResultRendererLibrary {
    private static HashMap<Class<? extends Result>, ResultRenderer> map;

    public static <T extends Result> void register(Class<? extends T> clazz, ResultRenderer<T> renderer) {
        if (map == null) {
            map = new HashMap();
        }
        map.put(clazz, renderer);
    }

    public static <T extends Result> ResultRenderer<T> getRenderer(T result) {
        ResultRenderer ren = map.get(result.getClass());
        if (ren == null) {
            Set<Class<? extends Result>> clazzes = map.keySet();
            for (Class<? extends Result> clazz : clazzes) {
                if (!clazz.isAssignableFrom(result.getClass())) continue;
                return map.get(clazz);
            }
        }
        if (ren == null) {
            System.err.println("Did not find a renderer for " + result.getClass() + ". Custom renderers need to be registered by " + ResultRendererLibrary.class.getName() + ".register().");
        }
        return ren;
    }

    static {
        TextResultRenderer.register();
        PlotGeneratorResultRenderer.register();
        ResultSetResultRenderer.register();
        ListResultRenderer.register();
        DataSetResultRenderer.register();
    }
}

