/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.renderers.results;

import de.jstacs.fx.renderers.results.ResultRenderer;
import de.jstacs.fx.renderers.results.ResultRendererLibrary;
import de.jstacs.parameters.FileParameter;
import de.jstacs.results.TextResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.util.Callback;

public class TextResultRenderer
implements ResultRenderer<TextResult> {
    public static void register() {
        ResultRendererLibrary.register(TextResult.class, new TextResultRenderer());
    }

    private TextResultRenderer() {
    }

    public static String[] getHeader(FileParameter.FileRepresentation rep) {
        String head = rep.getContent();
        int end = head.indexOf("\n");
        if (end < 0) {
            end = head.length();
        }
        head = head.substring(0, end);
        String[] parts = head.split("\t");
        boolean parsable = false;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].trim().length() <= 0) continue;
            try {
                Double.parseDouble(parts[i]);
                parsable = true;
                break;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String[] opts = null;
        opts = !parsable ? parts : new String[parts.length];
        return opts;
    }

    @Override
    public Node render(TextResult result, Pane parent) {
        if (TextResult.equals((String)result.getMime(), (String)"xml") || (double)result.getValue().getFilesize() > 2.0E7) {
            return null;
        }
        if (TextResult.equals((String)result.getMime(), (String)"bed,gff,gff3,tsv,csv")) {
            String cont;
            String[] lines;
            String sep = "\t";
            if ("csv".equalsIgnoreCase(result.getValue().getExtension())) {
                sep = ",";
            }
            String[] head = TextResultRenderer.getHeader(result.getValue());
            boolean hasHeader = true;
            if (head[0] == null) {
                for (int i = 0; i < head.length; ++i) {
                    head[i] = "Column " + (i + 1);
                }
                hasHeader = false;
            }
            if ((lines = (cont = result.getValue().getContent()).split("\n")).length > 0) {
                int j;
                int i = 0;
                if (hasHeader) {
                    i = 1;
                }
                Object[][] content = new Object[lines.length - i][];
                Class[] types = new Class[head.length];
                for (j = 0; j < content.length; ++j) {
                    String[] parts = lines[j + i].split(sep);
                    content[j] = new Object[parts.length];
                    for (int k = 0; k < parts.length; ++k) {
                        try {
                            Integer.parseInt(parts[k]);
                            if (types[k] == null || types[k].equals(Integer.class)) {
                                types[k] = Integer.class;
                            }
                        }
                        catch (NumberFormatException e) {
                            try {
                                Double.parseDouble(parts[k]);
                                if (types[k] == null || types[k].equals(Integer.class) || types[k].equals(Double.class)) {
                                    types[k] = Double.class;
                                }
                            }
                            catch (NumberFormatException ex) {
                                types[k] = String.class;
                            }
                        }
                        content[j][k] = parts[k];
                    }
                }
                for (j = 0; j < content.length; ++j) {
                    for (int k = 0; k < content[j].length; ++k) {
                        if (types[k].equals(Integer.class)) {
                            content[j][k] = Integer.parseInt((String)content[j][k]);
                            continue;
                        }
                        if (!types[k].equals(Double.class)) continue;
                        content[j][k] = Double.parseDouble((String)content[j][k]);
                    }
                }
                Object[] cols = new TableColumn[head.length];
                for (int j2 = 0; j2 < head.length; ++j2) {
                    final int col = j2;
                    if (types[j2] != null && Number.class.isAssignableFrom(types[j2])) {
                        TableColumn numCol = new TableColumn(head[j2]);
                        numCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Object[], Number>, ObservableValue<Number>>(){

                            public ObservableValue<Number> call(TableColumn.CellDataFeatures<Object[], Number> arg0) {
                                return new ReadOnlyObjectWrapper((Object)((Number)((Object[])arg0.getValue())[col]));
                            }
                        });
                        cols[j2] = numCol;
                        continue;
                    }
                    TableColumn strCol = new TableColumn(head[j2]);
                    strCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Object[], String>, ObservableValue<String>>(){

                        public ObservableValue<String> call(TableColumn.CellDataFeatures<Object[], String> arg0) {
                            return new ReadOnlyStringWrapper(((Object[])arg0.getValue())[col].toString());
                        }
                    });
                    cols[j2] = strCol;
                }
                final TableView tv = new TableView();
                tv.getColumns().addAll(cols);
                tv.setItems(FXCollections.observableArrayList((Object[])content));
                tv.getSelectionModel().selectionModeProperty().set((Object)SelectionMode.MULTIPLE);
                tv.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent event) {
                        KeyCodeCombination copyKeyCodeCombination = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY});
                        if (copyKeyCodeCombination.match(event)) {
                            ObservableList sel = tv.getSelectionModel().getSelectedIndices();
                            HashSet set = new HashSet(sel);
                            ArrayList sorted = new ArrayList(set);
                            Collections.sort(sorted);
                            StringBuffer sb = new StringBuffer();
                            for (int i = 0; i < sorted.size(); ++i) {
                                Object[] items = (Object[])tv.getItems().get(((Integer)sorted.get(i)).intValue());
                                for (int j = 0; j < items.length; ++j) {
                                    sb.append(items[j]);
                                    if (j >= items.length - 1) continue;
                                    sb.append("\t");
                                }
                                sb.append("\n");
                            }
                            ClipboardContent clipboardContent = new ClipboardContent();
                            clipboardContent.putString(sb.toString());
                            Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
                        }
                    }
                });
                return tv;
            }
        }
        final ListView lv = new ListView();
        ObservableList items = FXCollections.observableArrayList((Object[])result.getValue().getContent().split("\n"));
        lv.setItems(items);
        lv.getSelectionModel().selectionModeProperty().set((Object)SelectionMode.MULTIPLE);
        lv.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCodeCombination copyKeyCodeCombination = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY});
                if (copyKeyCodeCombination.match(event)) {
                    ObservableList sel = lv.getSelectionModel().getSelectedIndices();
                    HashSet set = new HashSet(sel);
                    ArrayList sorted = new ArrayList(set);
                    Collections.sort(sorted);
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < sorted.size(); ++i) {
                        sb.append((String)lv.getItems().get(((Integer)sorted.get(i)).intValue()));
                        sb.append("\n");
                    }
                    ClipboardContent clipboardContent = new ClipboardContent();
                    clipboardContent.putString(sb.toString());
                    Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
                }
            }
        });
        return lv;
    }
}

