/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx;

import de.jstacs.results.ResultSetResult;
import de.jstacs.utils.Pair;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;

public class TaskViewer
extends Stage {
    private TableView<Task<ResultSetResult>> table;

    public TaskViewer(final ObservableList<Task<ResultSetResult>> enqueued, final HashMap<Task<ResultSetResult>, Pair<String, Date>> nameMap) {
        TableColumn nameCol = new TableColumn("Name");
        nameCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Task<ResultSetResult>, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Task<ResultSetResult>, String> arg0) {
                return new ReadOnlyStringWrapper((String)((Pair)nameMap.get(arg0.getValue())).getFirstElement());
            }
        });
        TableColumn dateCol = new TableColumn("Date");
        dateCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Task<ResultSetResult>, Date>, ObservableValue<Date>>(){

            public ObservableValue<Date> call(TableColumn.CellDataFeatures<Task<ResultSetResult>, Date> arg0) {
                return new ReadOnlyObjectWrapper(((Pair)nameMap.get(arg0.getValue())).getSecondElement());
            }
        });
        TableColumn stateCol = new TableColumn("State");
        stateCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Task<ResultSetResult>, Worker.State>, ObservableValue<Worker.State>>(){

            public ObservableValue<Worker.State> call(TableColumn.CellDataFeatures<Task<ResultSetResult>, Worker.State> arg0) {
                return ((Task)arg0.getValue()).stateProperty();
            }
        });
        TableColumn removeColumn = new TableColumn("Cancel");
        removeColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Task<ResultSetResult>, Button>, ObservableValue<Button>>(){

            public ObservableValue<Button> call(final TableColumn.CellDataFeatures<Task<ResultSetResult>, Button> arg0) {
                Button btn = new Button("Cancel");
                btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent arg1) {
                        if (((Task)arg0.getValue()).isRunning()) {
                            ((Task)arg0.getValue()).cancel();
                        }
                        enqueued.remove(arg0.getValue());
                        nameMap.remove(arg0.getValue());
                    }
                });
                btn.disableProperty().bind((ObservableValue)((Task)arg0.getValue()).runningProperty());
                btn.visibleProperty().bind((ObservableValue)((Task)arg0.getValue()).runningProperty().not());
                return new ReadOnlyObjectWrapper((Object)btn);
            }
        });
        BorderPane border = new BorderPane();
        this.table = new TableView();
        this.table.getColumns().addAll((Object[])new TableColumn[]{nameCol, dateCol, stateCol, removeColumn});
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.table.setItems(enqueued);
        border.setCenter(this.table);
        Scene scene = new Scene((Parent)border, 700.0, 250.0);
        this.setScene(scene);
        this.hide();
        final TaskViewer st = this;
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent arg0) {
                st.hide();
            }
        });
        this.setAlwaysOnTop(true);
    }
}

