/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.repository;

import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.TextResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import de.jstacs.utils.Compression;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class ResultRepository {
    public static BooleanProperty autosave = new SimpleBooleanProperty(false);
    private static ResultRepository instance;
    private LinkedList<Result> results = new LinkedList();
    private ArrayList<ResultConsumer> consumers = new ArrayList();

    public static ResultRepository getInstance() {
        if (instance == null) {
            instance = new ResultRepository();
        }
        return instance;
    }

    private ResultRepository() {
        File f;
        if (autosave.get() && (f = new File("autosave.jst")).exists()) {
            try {
                StringBuffer sb = FileManager.readFile((File)f);
                sb = new StringBuffer(Compression.unzip((String)sb.toString()));
                this.restoreResultsFromXML(sb);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void notifyAdd(Result result) {
        for (int i = 0; i < this.consumers.size(); ++i) {
            this.consumers.get(i).notifyAdded(result);
        }
    }

    public void notifyRefresh(Result renamed) {
        for (int i = 0; i < this.consumers.size(); ++i) {
            this.consumers.get(i).notifyRefresh(renamed);
        }
    }

    public void add(Result result) {
        this.add(result, true);
    }

    public void add(Result result, boolean store) {
        this.results.add(result);
        this.notifyAdd(result);
        if (store) {
            this.autostore();
        }
    }

    public boolean autostore() {
        if (autosave.get()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileManager.writeFile((String)"autosave.jst", (CharSequence)Compression.zip((String)ResultRepository.this.storeResultsToXML().toString()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            return true;
        }
        return false;
    }

    private void notifyRemove(Result result) {
        for (int i = 0; i < this.consumers.size(); ++i) {
            this.consumers.get(i).notifyRemoved(result);
        }
    }

    public boolean remove(Result result) {
        boolean b = this.results.remove(result);
        if (b) {
            this.notifyRemove(result);
            this.autostore();
        }
        return b;
    }

    public List<Result> getAllResults() {
        List<Result> res = this.getResults();
        for (int i = 0; i < this.results.size(); ++i) {
            Result temp = this.results.get(i);
            if (!(temp instanceof ResultSetResult)) continue;
            Result[] temp2 = ((ResultSetResult)temp).getRawResult()[0].getResults();
            this.addAllResults(res, temp2);
        }
        return res;
    }

    private void addAllResults(List<Result> res, Result[] add) {
        for (int i = 0; i < add.length; ++i) {
            res.add(add[i]);
            if (!(add[i] instanceof ResultSetResult)) continue;
            Result[] temp2 = ((ResultSetResult)add[i]).getRawResult()[0].getResults();
            this.addAllResults(res, temp2);
        }
    }

    public List<Result> getResults() {
        return new ArrayList<Result>(this.results);
    }

    public List<Result> filterByMimeAndExtendedType(String mime, String extendedType) {
        ArrayList<Result> filtered = new ArrayList<Result>();
        for (Result r : this.getAllResults()) {
            String[] exts;
            if (r instanceof TextResult) {
                if (mime != null && !TextResult.equals((String)mime, (String)((TextResult)r).getMime()) || extendedType != null && ((TextResult)r).getExtendedType() != null && !TextResult.equals((String)extendedType, (String)((TextResult)r).getExtendedType())) continue;
                filtered.add(r);
                continue;
            }
            ResultSaver saver = ResultSaverLibrary.getSaver(r.getClass());
            if (saver == null || !TextResult.equals((String[])(exts = saver.getFileExtensions(r)), (String)mime)) continue;
            filtered.add(r);
        }
        return filtered;
    }

    public void register(ResultConsumer resultConsumer) {
        this.consumers.add(resultConsumer);
    }

    public ArrayList<ResultConsumer> getConsumers() {
        return this.consumers;
    }

    public void restoreResultsFromXML(StringBuffer sb) throws NonParsableException {
        Result[] temp = (Result[])XMLParser.extractObjectForTags((StringBuffer)sb, (String)"results");
        for (int i = 0; i < temp.length; ++i) {
            this.add(temp[i], false);
        }
    }

    public StringBuffer storeResultsToXML() {
        StringBuffer sb = new StringBuffer();
        Result[] temp = this.results.toArray(new Result[0]);
        XMLParser.appendObjectWithTags((StringBuffer)sb, (Object)temp, (String)"results");
        return sb;
    }

    public static interface ResultConsumer {
        public void notifyAdded(Result var1);

        public void notifyRemoved(Result var1);

        public void notifyRefresh(Result var1);
    }
}

