/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.parameters;

import de.jstacs.NonParsableException;

/**
 * Class for a <code>ParameterSet</code> that is constructed from an array of <code>Parameters</code>
 * and thus does nothing in the <code>loadParameters()</code>-method.
 * @author Jan Grau
 *
 */
public class SimpleParameterSet extends ParameterSet{

	/**
	 * Creates a new <code>SimpleParameterSet</code> from an array of <code>Parameter</code>s.
	 * @param parameters the parameters
	 */
	public SimpleParameterSet(Parameter[] parameters){
		super(parameters);
	}
	
	/**
	 * Constructs a <code>SimpleParameterSet</code> from its XML-representation
	 * @param representation the XML-representation
	 * @throws NonParsableException a <code>NonParsableException</code> is thrown if <code>representation</code> could not be parsed
	 */
	public SimpleParameterSet(StringBuffer representation) throws NonParsableException{
		super(representation);
	}
	
	public SimpleParameterSet clone() throws CloneNotSupportedException{
		SimpleParameterSet clone = (SimpleParameterSet)super.clone();
		return clone;
	}
    
    @Override
    public void reset(){
        if( parameters == null )
        {
            return;
        }
        for( int i = 0; i < parameters.size(); i++ )
        {
            parameters.get( i ).reset();
        }
    }
	
	@Override
	protected void loadParameters() {
				
	}

	@Override
	public String getInstanceName() {
		return null;
	}

	@Override
	public String getInstanceComment() {
		return null;
	}

}
