/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.utils.random;

import java.util.Random;

/**
 * This class is a multivariate random generator based on a Dirichlet
 * distribution for alpha_i \in N. It is a kind of &quot;multivariate Erlang distribution&quot;.
 * 
 * @author Jens Keilwagen
 */
public class ErlangMRG extends MultivariateRandomGenerator
{
	private Random r;
	
	public ErlangMRG()
	{
		r = new Random();
	}
	
	public void generate( double[] d, int start, int n, MRGParams p )
	{
		ErlangMRGParams param = (ErlangMRGParams) p;
		if( param.getDimension() != n )
		{
			throw new IllegalArgumentException( "Hyperparameter doesnot have a correct dimension." );
		}
		double sum = 0d;
		int i;
		for( i = 0; i < n; i++ )
		{
			d[start+i] = UnivariateRandomGenerator.erlangDistributed(param.getHyperparameter(i),r);
			sum += d[start+i];
		}
		//we obtain: i == n;
		i += start;
		for( ; start < i; start++ )
		{
			d[start] /= sum;
		}
	}
}
