/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.utils.random;

/**
 * The container for parameter of a Dirichlet random generator that used the same hyperparameter at all positions.
 * 
 * @author Jens Keilwagen
 * 
 * @see MRGParams
 * @see DirichletMRGParams
 */
public class FastDirichletMRGParams extends DiMRGParams
{
	private double alpha;

	public FastDirichletMRGParams( double alpha ) throws IllegalArgumentException
	{
		if( alpha <= 0d ) { throw new IllegalArgumentException( "The parameter alpha has to be positive." ); }
		this.alpha = alpha;
	}

	public int getDimension()
	{
		return -1;
	}

	public double getHyperparameter( int i )
	{
		return alpha;
	}
}
