/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs;

import de.jstacs.parameters.ParameterSet;

/**
 * Interface for all classes that can be instantiated from a <code>ParameterSet</code>. Each class <code>ABC</code>
 * implementing this interface <b>must</b> provide a constructor of kind<br>
 * <code>ABC(ParameterSet parameters)</code>.
 * 
 * <br>
 * <br>
 * 
 * In order to provide a suitable <code>ParameterSet</code> to obtain all necessary values of these variables the user
 * should implement a subclass of the abstract class <code>ParameterSet</code> or one of its subclasses, that creates
 * the necessary <code>Parameter</code>s in its <code>loadParameters()</code>-method.
 * 
 * @see de.jstacs.parameters.ParameterSet
 * @author Jan Grau, Jens Keilwagen
 * 
 */
public interface InstantiableFromParameterSet
{
	/**
	 * Returns the <code>ParameterSet</code> that has been used to instantiate the current instance of the implementing
	 * class. If the current instance was not created using a <code>ParameterSet</code>, an equivalent
	 * <code>ParameterSet</code> should be returned, such that an instance created using this
	 * <code>ParameterSet</code> would be in principle equal to the current instance.
	 * 
	 * @return the current <code>ParameterSet</code>
	 * @throws Exception
	 *             is thrown if the <code>ParameterSet</code> could not be returned
	 */
	public ParameterSet getCurrentParameterSet() throws Exception;

}
