/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.classifier.scoringFunctionBased;

import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.scoringFunctions.ScoringFunction;

/**
 * This is the main function for the ScoreClassifier.
 * 
 * @author Jens Keilwagen
 * 
 * @see de.jstacs.algorithms.optimization.Optimizer
 */
public abstract class OptimizableFunction extends DifferentiableFunction
{
	/**
	 * Returns the number of starts that should be done for a good optimum. For concave or convex functions this number should be 1.
	 * 
	 * @return the number of starts the Optimizer should be started to get a good optimum
	 * 
	 * @see de.jstacs.algorithms.optimization.Optimizer
	 */
	public abstract int getNumberOfStarts();

	/**
	 * Returns from the complete vector of parameters those that are for the classes.
	 * 
	 * @param params the current params
	 * 
	 * @return the parameters for the classes
	 */
	public abstract double[] getClassParams( double[] params );
	
	/**
	 * Returns some start parameters.
	 * 
	 * @param plugIn if some special parameters should be used as plug in parameter (e.g. MAP-parameters)
	 * 
	 * @return some start parameters
	 * 
	 * @throws Exception if something went wrong 
	 */
	public abstract double[] getStartParams( boolean plugIn ) throws Exception;

	/**
	 * Sets the current values as parameters
	 * 
	 * @param current
	 *            the current values
	 *            
	 * @throws DimensionException
	 *             if the dimension of the current values does not match with the internal parameters
	 */
	public abstract void setParams( double[] current ) throws DimensionException;
	
	/**
	 * Resets the scoringFunctions and all precomputed values.
	 * 
	 * @param score the array of scoringFunctions
	 * 
	 * @throws Exception if something went wrong 
	 */
	public abstract void reset( ScoringFunction[] score ) throws Exception;
}
