/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

/**
 * 
 */
package de.jstacs.data.alphabets;

import de.jstacs.NonParsableException;


/**
 * This abstract class indicates that an alphabet can be used for to compute the complement.
 * The most important method is {@link ComplementableDiscreteAlphabet#getComplementaryCode(int)}. 
 *  
 * @author Jan Grau, Jens Keilwagen
 */
public abstract class ComplementableDiscreteAlphabet extends DiscreteAlphabet {

	/**
	 * The constructor for the {@link de.jstacs.Storable} interface.
	 * 
	 * @param representation the xml representation
	 * 
	 * @throws NonParsableException if the stream is not parsable
	 */
	protected ComplementableDiscreteAlphabet( StringBuffer representation ) throws NonParsableException {
		super( representation );
	}

	/**
	 * The main constructor.
	 * 
	 * @param alphabet the array of symbols
	 * @param caseInsensitive 
	 * 
	 * @throws DoubleSymbolException
	 * @throws IllegalArgumentException
	 */
	protected ComplementableDiscreteAlphabet( String[] alphabet, boolean caseInsensitive ) throws DoubleSymbolException,
																						IllegalArgumentException {
		super( alphabet, caseInsensitive );
	}
	
	public abstract AlphabetParameterSet getCurrentParameterSet() throws Exception;
	
	/**
	 * This method returns the code of the symbol the is the complement of the symbol encoded by <code>code</code>
	 * 
	 * @param code the encoded symbol
	 * 
	 * @return the code of the complement
	 */
	public abstract int getComplementaryCode(int code);
}
