/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.parameters;

/**
 * Interface for <code>Parameter</code>s that potentially can be varied over a certain interval or a list of values.
 * If <code>isRangeable()</code> returns <code>true</code> an instance of a <code>RangeIterator</code> that is
 * defined equivalently (datatype, name, comment, etc.) to the current instance but can have multiple values can be
 * obtained using the <code>getRangedInstance()</code>-method.
 * 
 * @author Jan Grau
 * @see RangeIterator
 */
public interface Rangeable
{

	/**
	 * Returns true if the parameters can be varied over a range of values.
	 * 
	 * @return if the parameter can be varied
	 */
	public boolean isRangeable();

	/**
	 * Returns an instance of <code>RangeIterator</code> that has the same properties as the current instance, but
	 * accepts a range or list of values. These values can be obtained by the methods of <code>RangeIterator</code>.
	 * 
	 * @return the instance
	 * 
	 * @throws Exception
	 *             is thrown if <code>isRangeable()</code> returns <code>false</code> or the ranged instance could
	 *             not be created for some other reason
	 */
	public Parameter getRangedInstance() throws Exception;
}
