/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.utils;


/**
 * This class implements a <code>ProgressUpdater</code> doing nothing but forces a crossvalidation that
 * is used with an instance of this class to continue to its end. <br>
 * May be used, if no progress-update is wished during a crossvalidation.
 * 
 * @author Andre Gohr
 */
public class NullProgressUpdater implements ProgressUpdater{

	private static NullProgressUpdater NULLPROGRESSUPDATER = new NullProgressUpdater();
	
	private NullProgressUpdater
	() 
	{}
	
	/**
	 * @return always a reference to the same <code>NullProgressUpdater</code>
	 * that is immutable since all methods except <code>isCancelled</code>
	 * are not implemented. The method <code>isCancelled</code> always returns
	 * <b>false</b> to force the crossvalidation to continue.
	 */
	public static NullProgressUpdater getImmutableInstance
	(){
	return NullProgressUpdater.NULLPROGRESSUPDATER;
	}

	/**
	 * sets the maximal value that will be set by setValue(), so a value of max indicates the end of
	 * the supervised method call.
	 * 
	 * @param max the maximal value
	 */
	public void setMax
	( int max )
	{}

	/**
	 * sets the current value the supervised process has reached.
	 * 
	 * @param value the current value
	 */
	public void setValue
	( int value )
	{}

	/**
	 * closes the supervision
	 */
	public void close
	()
	{}

	/**
	 * after setOffset() is called the current value will be added to every value set by setValue()
	 */
	public void setOffset
	()
	{}

	/**
	 * Returns always <b>false</b> to continue the crossvalidation used with
	 * this <code>NullProgressUpdater</code>.
	 * 
	 * @return false
	 */
	public boolean isCancelled
	(){
	return false;
	}
	
}
