/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleResult
extends Result
implements Comparable<SimpleResult> {
    protected Comparable result;

    protected SimpleResult(String name, String comment, DataType datatype) {
        super(name, comment, datatype);
    }

    protected SimpleResult(StringBuffer rep) throws NonParsableException {
        super(rep);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        this.appendMainInfo(buf);
        XMLParser.appendStringWithTags(buf, this.result.toString(), "result");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        this.extractMainInfo(representation);
        switch (this.datatype) {
            case STRING: {
                this.result = XMLParser.extractStringForTag(representation, "result");
                break;
            }
            case BOOLEAN: {
                this.result = Boolean.valueOf(XMLParser.extractBooleanForTag(representation, "result"));
                break;
            }
            case INT: {
                this.result = Integer.valueOf(XMLParser.extractIntForTag(representation, "result"));
                break;
            }
            case LONG: {
                this.result = Long.valueOf(XMLParser.extractLongForTag(representation, "result"));
                break;
            }
            case DOUBLE: {
                this.result = Double.valueOf(XMLParser.extractDoubleForTag(representation, "result"));
            }
            default: {
                throw new NonParsableException("Result not of expected datatype");
            }
        }
    }

    void setResult(Comparable newValue) throws SimpleParameter.IllegalValueException {
        this.set(newValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void set(Comparable result) throws SimpleParameter.IllegalValueException {
        if (this.datatype == DataType.DOUBLE && (result instanceof Double || result instanceof Float)) {
            this.result = result instanceof Float ? new Double(((Float)result).doubleValue()) : result;
            return;
        } else if (this.datatype == DataType.INT && (result instanceof Integer || result instanceof Byte || result instanceof Short)) {
            this.result = result instanceof Byte ? new Integer(((Byte)result).intValue()) : (result instanceof Short ? new Integer(((Short)result).intValue()) : result);
            return;
        } else if (this.datatype == DataType.LONG && result instanceof Long) {
            this.result = result;
            return;
        } else if (this.datatype == DataType.BOOLEAN && result instanceof Boolean) {
            this.result = result;
            return;
        } else if (this.datatype == DataType.STRING && result instanceof String) {
            this.result = result;
            return;
        } else {
            if (!(result instanceof String)) throw new SimpleParameter.IllegalValueException("Value not of the expected datatype!");
            if (this.datatype == DataType.DOUBLE) {
                this.result = new Double((String)((Object)result));
                return;
            } else if (this.datatype == DataType.INT) {
                this.result = new Integer((String)((Object)result));
                return;
            } else if (this.datatype == DataType.BOOLEAN) {
                this.result = new Boolean((String)((Object)result));
                return;
            } else {
                if (this.datatype != DataType.LONG) throw new SimpleParameter.IllegalValueException("Value not of the expected datatype!");
                this.result = new Long((String)((Object)result));
            }
        }
    }

    @Override
    public Comparable getResult() {
        return this.result;
    }

    public String toString() {
        return this.name + ": " + this.result.toString();
    }

    @Override
    public int compareTo(SimpleResult r) {
        if (this.datatype != r.datatype) {
            return this.datatype.ordinal() - r.datatype.ordinal();
        }
        int c = this.name.compareTo(r.name);
        if (c != 0) {
            return c;
        }
        c = this.comment.compareTo(r.comment);
        if (c != 0) {
            return c;
        }
        return this.result.compareTo(r.result);
    }

    public boolean equals(Object arg) {
        if (arg instanceof SimpleResult) {
            return this.compareTo((SimpleResult)arg) == 0;
        }
        return false;
    }
}

