/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.directedGraphicalModels.Parameter;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterTree
implements Cloneable {
    private int pos;
    private int[] contextPoss;
    private TreeElement root;
    private AlphabetContainer alphabet;
    private int firstParent;
    private int[] firstChildren;

    public ParameterTree(int pos, int[] contextPoss, AlphabetContainer alphabet, int firstParent, int[] firstChildren) {
        this.pos = pos;
        this.contextPoss = contextPoss;
        this.alphabet = alphabet;
        this.firstParent = firstParent;
        this.firstChildren = firstChildren;
        this.root = new TreeElement(0, alphabet);
    }

    public ParameterTree(StringBuffer source, AlphabetContainer alphabet) throws NonParsableException {
        try {
            source = XMLParser.extractForTag(source, "parameterTree");
            this.pos = XMLParser.extractIntForTag(source, "pos");
            this.contextPoss = XMLParser.extractIntArrayForTag(source, "contextPoss");
            this.root = new TreeElement(XMLParser.extractForTag(source, "root"));
            this.alphabet = alphabet;
            this.firstParent = XMLParser.extractIntForTag(source, "firstParent");
            this.firstChildren = XMLParser.extractIntArrayForTag(source, "firstChildren");
        }
        catch (NonParsableException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public ParameterTree clone() throws CloneNotSupportedException {
        ParameterTree clone = (ParameterTree)super.clone();
        clone.contextPoss = (int[])this.contextPoss.clone();
        clone.cloneRoot();
        clone.firstChildren = (int[])this.firstChildren.clone();
        return clone;
    }

    private void cloneRoot() throws CloneNotSupportedException {
        TreeElement temp = this.root;
        this.root = new TreeElement(this.root.contNum, this.alphabet);
        this.root.cloneRest(temp);
    }

    public String toString() {
        StringBuffer all = new StringBuffer();
        all.append("Probabilities at position " + this.pos + ":\n");
        this.root.appendToBuffer(all, "");
        return all.toString();
    }

    public void insertProbs(double[] probs) throws Exception {
        this.root.insertProbs(probs);
    }

    public LinkedList<Parameter> linearizeParameters() {
        return this.root.linearizeParameters(new LinkedList());
    }

    public boolean isLeaf() {
        return this.firstChildren.length == 0;
    }

    public int getNumberOfParents() {
        return this.contextPoss.length;
    }

    public void print() {
        System.out.println("tree " + this.pos + ": ");
        this.root.print();
    }

    public Parameter getParameterFor(Sequence seq, int start) {
        return this.root.getParameterFor(seq, start);
    }

    public void setParameterFor(int symbol, int[][] context, Parameter par) {
        this.root.setParameterFor(0, symbol, context, par);
    }

    public void invalidateNormalizers() {
        this.root.invalidateNormalizers();
    }

    public double forward(ParameterTree[] trees) throws RuntimeException {
        if (this.getNumberOfParents() > 0) {
            throw new RuntimeException("Forward can only be started at roots.");
        }
        return this.getZ(new int[0][2], trees);
    }

    private double getZ(int[][] context, ParameterTree[] trees) throws RuntimeException {
        return this.root.getZ(context, new int[this.getNumberOfParents() + 1][2], trees, 0);
    }

    private double getT(int[][] context, ParameterTree[] trees, int[][] order) throws RuntimeException {
        return this.root.getT(context, this.firstParent > -1 ? new int[trees[this.firstParent].contextPoss.length + 1][2] : new int[0][2], trees, order, 0);
    }

    public void backward(ParameterTree[] trees, int[][] order) throws RuntimeException {
        if (!this.isLeaf()) {
            throw new RuntimeException("Backward can only be started at leaves.");
        }
        this.root.startBackward(new int[this.getNumberOfParents() + 1][2], trees, order, 0);
    }

    public void addCount(Sequence seq, int start, double count) {
        this.getParameterFor(seq, start).addCount(count);
    }

    public void normalizePlugInParameters() {
        this.root.normalizePlugInParameters();
    }

    public void normalizeParameters() {
        this.root.normalizeParameters();
    }

    public void divideByUnfree() {
        this.root.divideByUnfree();
    }

    public StringBuffer toXML() {
        StringBuffer source = new StringBuffer();
        XMLParser.appendIntWithTags(source, this.pos, "pos");
        XMLParser.appendIntArrayWithTags(source, this.contextPoss, "contextPoss");
        XMLParser.appendStorableWithTags(source, this.root, "root");
        XMLParser.appendIntWithTags(source, this.firstParent, "firstParent");
        XMLParser.appendIntArrayWithTags(source, this.firstChildren, "firstChildren");
        XMLParser.addTags(source, "parameterTree");
        return source;
    }

    public static String[] toStringArray(ParameterTree[] trees) {
        String[] strs = new String[trees.length];
        for (int i = 0; i < trees.length; ++i) {
            strs[i] = trees[i].toXML().toString();
        }
        return strs;
    }

    public static ParameterTree[] fromStringArray(String[] strs, AlphabetContainer alphabet) throws NonParsableException {
        ParameterTree[] trees = new ParameterTree[strs.length];
        for (int i = 0; i < trees.length; ++i) {
            trees[i] = new ParameterTree(new StringBuffer(strs[i]), alphabet);
        }
        return trees;
    }

    public int getFirstParent() {
        return this.firstParent;
    }

    public double getKLDivergence(double[] q) {
        return this.root.getKLDivergence(q);
    }

    public void fill(double[] fillEmptyWith) {
        this.root.fill(fillEmptyWith);
    }

    public void copy(ParameterTree parameterTree) {
        this.root.copy(parameterTree.root);
    }

    public void initializeRandomly(double ess) {
        this.root.initializeRandomly(ess);
    }

    public Double computeGammaNorm() {
        return this.root.computeGammaNorm();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeElement
    implements Storable,
    Cloneable {
        private int contextPos;
        private TreeElement[] children;
        private Parameter[] pars;
        private Double fullNormalizer;
        private Double[] symT;
        private int contNum;

        private TreeElement(int contNum, AlphabetContainer alphabet) {
            this.contNum = contNum;
            if (contNum < ParameterTree.this.contextPoss.length) {
                this.contextPos = ParameterTree.this.contextPoss[contNum];
                this.children = new TreeElement[(int)alphabet.getAlphabetLengthAt(this.contextPos)];
                int i = 0;
                while ((double)i < alphabet.getAlphabetLengthAt(this.contextPos)) {
                    this.children[i] = new TreeElement(contNum + 1, alphabet);
                    ++i;
                }
            } else {
                this.contextPos = -1;
                this.pars = new Parameter[(int)alphabet.getAlphabetLengthAt(ParameterTree.this.pos)];
                this.fullNormalizer = null;
                this.symT = new Double[this.pars.length];
            }
        }

        private void appendToBuffer(StringBuffer all, String after) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].appendToBuffer(all, after + "X_" + this.contextPos + " = " + ParameterTree.this.alphabet.getSymbol(this.contextPos, i) + ", ");
                }
            } else {
                int i;
                double norm = 0.0;
                for (i = 0; i < this.pars.length; ++i) {
                    norm += this.pars[i].getExpValue() * this.pars[i].getZ();
                }
                for (i = 0; i < this.pars.length; ++i) {
                    double tempTheta = this.pars[i].getExpValue() * this.pars[i].getZ() / norm;
                    all.append("P(X_" + ParameterTree.this.pos + " = " + ParameterTree.this.alphabet.getSymbol(ParameterTree.this.pos, i) + " | " + after + "c)=" + tempTheta);
                    if (i >= this.pars.length - 1) continue;
                    all.append("\t");
                }
                all.append("\n");
            }
        }

        private void normalizeParameters() {
            block5: {
                int i;
                block4: {
                    if (this.children == null) break block4;
                    for (int i2 = 0; i2 < this.children.length; ++i2) {
                        this.children[i2].normalizeParameters();
                    }
                    break block5;
                }
                double norm = 0.0;
                for (i = 0; i < this.pars.length; ++i) {
                    norm += this.pars[i].getExpValue() * this.pars[i].getZ();
                }
                for (i = 0; i < this.pars.length; ++i) {
                    double tempTheta = this.pars[i].getExpValue() * this.pars[i].getZ() / norm;
                    this.pars[i].setValue(Math.log(tempTheta));
                }
                if (this.pars[this.pars.length - 1].isFree()) break block5;
                for (i = 0; i < this.pars.length; ++i) {
                    this.pars[i].setValue(this.pars[i].getValue() - this.pars[this.pars.length - 1].getValue());
                }
            }
        }

        private void insertProbs(double[] probs) throws Exception {
            if (this.children != null) {
                throw new Exception("Not implemented");
            }
            for (int i = 0; i < this.pars.length; ++i) {
                probs[i] = this.pars[i].getValue() + Math.log(this.pars[i].getZ());
            }
            Normalisation.logSumNormalisation(probs);
        }

        private void startBackward(int[][] newContext, ParameterTree[] trees, int[][] order, int depth) throws RuntimeException {
            if (this.children != null) {
                newContext[depth][0] = this.contextPos;
                for (int i = 0; i < this.children.length; ++i) {
                    newContext[depth][1] = i;
                    this.children[i].startBackward(newContext, trees, order, depth + 1);
                }
            } else {
                newContext[depth][0] = ParameterTree.this.pos;
                for (int i = 0; i < this.pars.length; ++i) {
                    newContext[depth][1] = this.pars[i].symbol;
                    trees[ParameterTree.this.pos].getT(newContext, trees, order);
                }
            }
        }

        private double getT(int[][] context, int[][] newContext, ParameterTree[] trees, int[][] order, int depth) throws RuntimeException {
            if (this.children != null) {
                for (int i = 0; i < context.length; ++i) {
                    if (context[i][0] != this.contextPos) continue;
                    newContext[depth][0] = context[i][0];
                    newContext[depth][1] = context[i][1];
                    return this.children[context[i][1]].getT(context, newContext, trees, order, depth + 1);
                }
                throw new RuntimeException("Correct context not found for depth " + depth + " at position " + ParameterTree.this.pos + ".");
            }
            for (int i = 0; i < context.length; ++i) {
                if (context[i][0] != ParameterTree.this.pos) continue;
                for (int j = 0; j < this.pars.length; ++j) {
                    if (this.pars[j].symbol != context[i][1]) continue;
                    if (this.symT[j] != null) {
                        return this.symT[j];
                    }
                    int fp = ParameterTree.this.firstParent;
                    if (fp == -1) {
                        this.pars[j].setT(1.0);
                        return this.pars[j].getExpValue();
                    }
                    if (trees[fp].contextPoss.length < ParameterTree.this.contextPoss.length) {
                        double temp = trees[fp].getT(newContext, trees, order);
                        int[] fcoffp = trees[fp].firstChildren;
                        for (int k = 0; k < fcoffp.length; ++k) {
                            if (fcoffp[k] == ParameterTree.this.pos) continue;
                            temp *= trees[fcoffp[k]].getZ(newContext, trees);
                        }
                        this.pars[j].setT(temp);
                        this.symT[j] = this.pars[j].getExpValue() * temp;
                        return this.symT[j];
                    }
                    int[] cp = trees[fp].contextPoss;
                    int lowestOrder = Integer.MAX_VALUE;
                    int lowestOrderIndex = -1;
                    for (int k = 0; k < cp.length; ++k) {
                        if (order[cp[k]][1] >= lowestOrder) continue;
                        lowestOrder = order[cp[k]][1];
                        lowestOrderIndex = cp[k];
                    }
                    newContext[depth][0] = lowestOrderIndex;
                    double temp = 0.0;
                    int a = 0;
                    while ((double)a < ParameterTree.this.alphabet.getAlphabetLengthAt(lowestOrderIndex)) {
                        newContext[depth][1] = a;
                        double temp2 = trees[fp].getT(newContext, trees, order);
                        int[] fcoffp = trees[fp].firstChildren;
                        for (int k = 0; k < fcoffp.length; ++k) {
                            if (fcoffp[k] == ParameterTree.this.pos) continue;
                            temp2 *= trees[fcoffp[k]].getZ(newContext, trees);
                        }
                        temp += temp2;
                        a = (byte)(a + 1);
                    }
                    this.pars[j].setT(temp);
                    this.symT[j] = this.pars[j].getExpValue() * temp;
                    return this.symT[j];
                }
            }
            throw new RuntimeException("Parameter value not defined in context.");
        }

        private double getZ(int[][] context, int[][] newContext, ParameterTree[] trees, int depth) throws RuntimeException {
            if (this.children != null) {
                for (int i = 0; i < context.length; ++i) {
                    if (context[i][0] != this.contextPos) continue;
                    newContext[depth][0] = context[i][0];
                    newContext[depth][1] = context[i][1];
                    return this.children[context[i][1]].getZ(context, newContext, trees, depth + 1);
                }
                throw new RuntimeException("Correct context could not be found at position " + ParameterTree.this.pos + " and depth " + depth);
            }
            if (this.fullNormalizer != null) {
                return this.fullNormalizer;
            }
            double val = 0.0;
            for (int i = 0; i < this.pars.length; ++i) {
                int[] fc = ParameterTree.this.firstChildren;
                if (fc == null) {
                    throw new RuntimeException("First children of parameter " + this.pars[i].getIndex() + " not defined.");
                }
                newContext[depth][0] = this.pars[i].getPosition();
                newContext[depth][1] = this.pars[i].symbol;
                double temp = 1.0;
                for (int j = 0; j < fc.length; ++j) {
                    temp *= trees[fc[j]].getZ(newContext, trees);
                }
                this.pars[i].setZ(temp);
                val += this.pars[i].getExpValue() * temp;
            }
            this.fullNormalizer = val;
            return this.fullNormalizer;
        }

        private void invalidateNormalizers() {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].invalidateNormalizers();
                }
            } else {
                for (int i = 0; i < this.pars.length; ++i) {
                    this.pars[i].invalidateNormalizers();
                    this.symT[i] = null;
                }
            }
            this.fullNormalizer = null;
        }

        private void cloneRest(TreeElement original) throws CloneNotSupportedException {
            int i;
            this.contextPos = original.contextPos;
            if (this.children != null) {
                this.children = new TreeElement[this.children.length];
                for (i = 0; i < this.children.length; ++i) {
                    this.children[i] = new TreeElement(original.children[i].contNum, ParameterTree.this.alphabet);
                    this.children[i].cloneRest(original.children[i]);
                }
            } else {
                this.children = null;
            }
            if (this.pars != null) {
                this.pars = new Parameter[this.pars.length];
                for (i = 0; i < this.pars.length; ++i) {
                    this.pars[i] = original.pars[i].clone();
                }
                this.fullNormalizer = null;
                this.symT = new Double[this.pars.length];
            }
        }

        private void divideByUnfree() {
            if (this.pars != null) {
                double div = this.pars[this.pars.length - 1].getValue();
                for (int i = 0; i < this.pars.length; ++i) {
                    if (!Double.isNaN(this.pars[i].getValue() - div) && !Double.isInfinite(this.pars[i].getValue() - div)) {
                        this.pars[i].setValue(this.pars[i].getValue() - div);
                        continue;
                    }
                    this.pars[i].setValue(0.0);
                }
            } else {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].divideByUnfree();
                }
            }
        }

        private LinkedList<Parameter> linearizeParameters(LinkedList<Parameter> list) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].linearizeParameters(list);
                }
            } else {
                for (int i = 0; i < this.pars.length; ++i) {
                    list.add(this.pars[i]);
                }
            }
            return list;
        }

        private TreeElement(StringBuffer representation) throws NonParsableException {
            representation = XMLParser.extractForTag(representation, "treeElement");
            this.contNum = XMLParser.extractIntForTag(representation, "contNum");
            this.contextPos = XMLParser.extractIntForTag(representation, "contextPos");
            StringBuffer temp = XMLParser.extractForTag(representation, "children");
            if (temp.toString().equals("null")) {
                this.children = null;
            } else {
                XMLParser.addTags(temp, "children");
                String[] childRep = XMLParser.extractStringArrayForTag(temp, "children");
                this.children = new TreeElement[childRep.length];
                for (int i = 0; i < childRep.length; ++i) {
                    this.children[i] = new TreeElement(new StringBuffer(childRep[i]));
                }
            }
            temp = XMLParser.extractForTag(representation, "pars");
            if (temp.toString().equals("null")) {
                this.pars = null;
            } else {
                XMLParser.addTags(temp, "pars");
                this.pars = (Parameter[])ArrayHandler.cast(XMLParser.extractStorableArrayForTag(temp, "pars"));
            }
            if (this.pars != null) {
                this.symT = new Double[this.pars.length];
                this.fullNormalizer = null;
            }
        }

        private void setParameterFor(int depth, int symbol, int[][] context, Parameter par) {
            if (this.children != null) {
                for (int i = 1; i < context[depth].length; ++i) {
                    this.children[context[depth][i]].setParameterFor(depth + 1, symbol, context, par);
                }
            } else {
                this.pars[symbol] = par;
            }
        }

        private void print() {
            System.out.println(this.contextPos);
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    System.out.println("child " + i + ":");
                    this.children[i].print();
                }
            } else {
                for (int i = 0; i < this.pars.length; ++i) {
                    this.pars[i].print();
                }
            }
        }

        private void normalizePlugInParameters() {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].normalizePlugInParameters();
                }
            } else {
                int i;
                double sum = 0.0;
                for (i = 0; i < this.pars.length; ++i) {
                    sum += this.pars[i].getCounts();
                }
                if (sum > 0.0) {
                    for (i = 0; i < this.pars.length; ++i) {
                        this.pars[i].setValue(Math.log(this.pars[i].getCounts() / sum));
                    }
                } else {
                    for (i = 0; i < this.pars.length; ++i) {
                        this.pars[i].setValue(-Math.log(this.pars.length));
                    }
                }
            }
        }

        private Parameter getParameterFor(Sequence seq, int start) {
            if (this.children != null) {
                return this.children[seq.discreteVal(this.contextPos + start)].getParameterFor(seq, start);
            }
            return this.pars[seq.discreteVal(ParameterTree.this.pos + start)];
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer source = new StringBuffer();
            XMLParser.appendIntWithTags(source, this.contNum, "contNum");
            XMLParser.appendIntWithTags(source, this.contextPos, "contextPos");
            if (this.children != null) {
                XMLParser.appendStorableArrayWithTags(source, this.children, "children");
            } else {
                XMLParser.appendStringWithTags(source, "null", "children");
            }
            if (this.pars != null) {
                XMLParser.appendStorableArrayWithTags(source, this.pars, "pars");
            } else {
                XMLParser.appendStringWithTags(source, "null", "pars");
            }
            XMLParser.addTags(source, "treeElement");
            return source;
        }

        private double getKLDivergence(double[] q) {
            int i;
            if (this.children != null) {
                double val = 0.0;
                for (int i2 = 0; i2 < this.children.length; ++i2) {
                    val += this.children[i2].getKLDivergence(q);
                }
                return val / (double)q.length;
            }
            double val = 0.0;
            double norm = 0.0;
            for (i = 0; i < this.pars.length; ++i) {
                norm += this.pars[i].getExpValue() * this.pars[i].getZ();
            }
            for (i = 0; i < this.pars.length; ++i) {
                double temp = this.pars[i].getExpValue() * this.pars[i].getZ() / norm;
                val += temp * Math.log(temp / q[i]);
            }
            return val;
        }

        private void fill(double[] fillEmptyWith) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].fill(fillEmptyWith);
                }
            } else if (this.pars[this.pars.length - 1].isFree()) {
                if (fillEmptyWith.length != this.pars.length) {
                    throw new IndexOutOfBoundsException("Different number of values (" + fillEmptyWith.length + ") than free parameters (" + this.pars.length + ").");
                }
                for (int i = 0; i < this.pars.length; ++i) {
                    this.pars[i].setValue(Math.log(fillEmptyWith[i]));
                }
            } else {
                for (int i = 0; i < this.pars.length - 1; ++i) {
                    this.pars[i].setValue(Math.log(fillEmptyWith[i]) - Math.log(fillEmptyWith[this.pars.length - 1]));
                }
            }
        }

        private void copy(TreeElement node) {
            if (this.children != null) {
                if (node.children != null) {
                    if (this.children.length != node.children.length) {
                        throw new IndexOutOfBoundsException("Different number of children.");
                    }
                    for (int i = 0; i < this.children.length; ++i) {
                        this.children[i].copy(node.children[i]);
                    }
                } else {
                    for (int i = 0; i < this.children.length; ++i) {
                        this.children[i].copy(node);
                    }
                }
            } else if (node.pars != null) {
                if (this.pars.length != node.pars.length) {
                    throw new IndexOutOfBoundsException("Different number of parameters.");
                }
                for (int i = 0; i < this.pars.length; ++i) {
                    this.pars[i].setValue(node.pars[i].getValue());
                }
            } else {
                double[] vals = new double[this.pars.length];
                for (int i = 0; i < this.pars.length; ++i) {
                    double res;
                    vals[i] = res = node.getLogSum(i);
                    this.pars[i].setValue(res);
                }
                double norm = Normalisation.getLogSum(vals);
                for (int i = 0; i < this.pars.length; ++i) {
                    this.pars[i].setValue(this.pars[i].getValue() - norm);
                }
            }
        }

        private double getLogSum(int idx) {
            if (this.children != null) {
                double[] vals = new double[this.children.length];
                for (int i = 0; i < vals.length; ++i) {
                    vals[i] = this.children[i].getLogSum(idx);
                }
                double ret = Normalisation.getLogSum(vals);
                return ret;
            }
            return this.getLogSumForLeaf(idx);
        }

        private double getLogSumForLeaf(int idx) {
            return this.pars[idx].getValue() + Math.log(this.pars[idx].getT());
        }

        private void initializeRandomly(double ess) {
            if (this.pars != null) {
                if (ess <= 0.0) {
                    ess = ParameterTree.this.alphabet.getAlphabetLengthAt(this.pars[0].getPosition());
                }
                double[] hyp = new double[this.pars.length];
                for (int i = 0; i < hyp.length; ++i) {
                    hyp[i] = ess / ParameterTree.this.alphabet.getAlphabetLengthAt(this.pars[i].getPosition());
                }
                double[] temp = DirichletMRG.DEFAULT_INSTANCE.generate(this.pars.length, new DirichletMRGParams(hyp));
                for (int i = 0; i < this.pars.length; ++i) {
                    this.pars[i].count = temp[i];
                }
                this.normalizePlugInParameters();
                if (!this.pars[this.pars.length - 1].isFree()) {
                    this.divideByUnfree();
                }
            } else {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].initializeRandomly(ess / ParameterTree.this.alphabet.getAlphabetLengthAt(this.contextPos));
                }
            }
        }

        private double computeGammaNorm() {
            if (this.children != null) {
                double val = 0.0;
                for (int i = 0; i < this.children.length; ++i) {
                    val += this.children[i].computeGammaNorm();
                }
                return val;
            }
            double val = 0.0;
            double hypSum = 0.0;
            for (int i = 0; i < this.pars.length; ++i) {
                double alpha = this.pars[i].getPseudoCount();
                hypSum += alpha;
                val -= Gamma.logOfGamma((double)alpha);
            }
            return val += Gamma.logOfGamma((double)hypSum);
        }
    }
}

