/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.random;

import de.jstacs.utils.random.MRGParams;
import de.jstacs.utils.random.MultivariateRandomGenerator;
import java.util.Arrays;
import java.util.Random;

public class SoftOneOfN
extends MultivariateRandomGenerator {
    private Random r = new Random();
    private double epsilon;
    private double p;

    public SoftOneOfN(double epsilon) throws IllegalArgumentException {
        if (epsilon < 0.0 || epsilon > 1.0) {
            throw new IllegalArgumentException("The value of epsilon has to be in [0,1]");
        }
        this.epsilon = epsilon;
        this.p = 1.0 - epsilon;
    }

    public SoftOneOfN() {
        this(0.0);
    }

    public void generate(double[] d, int start, int number, MRGParams p) {
        this.generate(d, start, number);
    }

    public double[] generate(int number) {
        double[] erg = new double[number];
        this.generate(erg, 0, number);
        return erg;
    }

    public void generate(double[] d, int start, int number) {
        Arrays.fill(d, start, start + number, this.epsilon / (double)(number - 1));
        d[start + this.r.nextInt((int)number)] = this.p;
    }
}

