/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation.bestFitting;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.BasisFunction;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.LinearFunctionSpaceElement;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.Sample;
import de.jtem.numericalMethods.calculus.minimizing.ConjugateGradient;

public class LinearFunctionSpace {
    BasisFunction[][] f;
    public final int n;
    public final int m;
    public final int dim;
    double[][] c;

    LinearFunctionSpace(BasisFunction[][] basisFunctionArray) {
        this.f = basisFunctionArray;
        this.n = basisFunctionArray[0][0].getNumberOfVariables();
        this.m = basisFunctionArray[0].length;
        this.dim = basisFunctionArray.length;
        this.c = new double[this.dim][this.m];
    }

    public int getDimension() {
        return this.m * this.dim;
    }

    void eval(double[] dArray, double[] dArray2, double[] dArray3) {
        this.eval(dArray, dArray2, dArray3, this.c);
    }

    void eval(double[] dArray, double[] dArray2, double[] dArray3, double[][] dArray4) {
        int n;
        for (n = 0; n < this.m; ++n) {
            dArray3[n] = 0.0;
        }
        int n2 = 0;
        for (n = 0; n < this.dim; ++n) {
            int n3 = 0;
            while (n3 < this.m) {
                double d;
                dArray4[n][n3] = d = this.f[n][n3].eval(dArray);
                int n4 = n3++;
                dArray3[n4] = dArray3[n4] + dArray2[n2] * d;
                ++n2;
            }
        }
    }

    public LinearFunctionSpaceElement searchForBestFit(double[] dArray, Sample[] sampleArray, double d, int n) {
        LinearFunctionSpaceElement linearFunctionSpaceElement = new LinearFunctionSpaceElement(this);
        Energy energy = new Energy(sampleArray);
        ConjugateGradient.search(linearFunctionSpaceElement.coefficient, d, energy, n, false, null);
        return linearFunctionSpaceElement;
    }

    public LinearFunctionSpaceElement searchForBestFit(LinearFunctionSpaceElement linearFunctionSpaceElement, Sample[] sampleArray, double d, int n) {
        return this.searchForBestFit(linearFunctionSpaceElement, sampleArray, d, n, 0);
    }

    public LinearFunctionSpaceElement searchForBestFit(LinearFunctionSpaceElement linearFunctionSpaceElement, Sample[] sampleArray, double d, int n, int n2) {
        LinearFunctionSpaceElement linearFunctionSpaceElement2 = new LinearFunctionSpaceElement(this, linearFunctionSpaceElement.getCoefficients());
        Energy energy = new Energy(sampleArray, n2);
        ConjugateGradient.search(linearFunctionSpaceElement2.coefficient, d, energy, n, false, null);
        return linearFunctionSpaceElement2;
    }

    public LinearFunctionSpaceElement searchForBestFit(Sample[] sampleArray, double d, int n) {
        return this.searchForBestFit(new LinearFunctionSpaceElement(this), sampleArray, d, n);
    }

    class Energy
    implements RealFunctionOfSeveralVariablesWithGradient {
        final Sample[] samples;
        final double[] y;
        final int numberOfDimensionBeingFixed;

        Energy(Sample[] sampleArray, int n) {
            this.samples = sampleArray;
            this.numberOfDimensionBeingFixed = n;
            this.y = new double[LinearFunctionSpace.this.m];
        }

        Energy(Sample[] sampleArray) {
            this(sampleArray, 0);
        }

        final double absSqr(double[] dArray) {
            double d = 0.0;
            for (int i = 0; i < LinearFunctionSpace.this.m; ++i) {
                d += dArray[i] * dArray[i];
            }
            return d;
        }

        public double eval(double[] dArray, double[] dArray2) {
            int n;
            double d = 0.0;
            if (dArray2 != null) {
                for (n = 0; n < LinearFunctionSpace.this.m * LinearFunctionSpace.this.dim; ++n) {
                    dArray2[n] = 0.0;
                }
            }
            for (n = 0; n < this.samples.length; ++n) {
                int n2;
                Sample sample = this.samples[n];
                LinearFunctionSpace.this.eval(sample.x, dArray, this.y, LinearFunctionSpace.this.c);
                for (n2 = 0; n2 < LinearFunctionSpace.this.m; ++n2) {
                    int n3 = n2;
                    this.y[n3] = this.y[n3] - sample.y[n2];
                }
                if (dArray2 != null) {
                    int n4 = LinearFunctionSpace.this.m * this.numberOfDimensionBeingFixed;
                    for (n2 = this.numberOfDimensionBeingFixed; n2 < LinearFunctionSpace.this.dim; ++n2) {
                        for (int i = 0; i < LinearFunctionSpace.this.m; ++i) {
                            int n5 = n4++;
                            dArray2[n5] = dArray2[n5] + LinearFunctionSpace.this.c[n2][i] * this.y[i] * sample.weight;
                        }
                    }
                }
                d += this.absSqr(this.y) * sample.weight;
            }
            return d / 2.0;
        }

        public double eval(double[] dArray) {
            return this.eval(dArray, null);
        }

        public int getNumberOfVariables() {
            return LinearFunctionSpace.this.getDimension();
        }
    }
}

