/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.integration.RealVectorValuedFunctionIntegrator;
import de.jtem.numericalMethods.calculus.odeSolving.ODE;
import de.jtem.numericalMethods.calculus.odeSolving.OdeSolver;
import java.io.Serializable;

abstract class OdeSolverBasedIntegrator
implements Serializable,
RealVectorValuedFunctionIntegrator {
    private static final long serialVersionUID = 1L;
    private int numberOfFunctions;
    OdeSolver odeSolver;
    WraperFunction wf;
    double[] I;
    double startX;

    OdeSolverBasedIntegrator(OdeSolver odeSolver) {
        this.odeSolver = odeSolver;
    }

    public OdeSolver getOdeSolver() {
        return this.odeSolver;
    }

    private void changeNumberOfFunctions(int n) {
        this.I = new double[n];
        this.numberOfFunctions = n;
    }

    public void setFunction(RealFunctionOfOneVariable realFunctionOfOneVariable) {
        this.wf = new WraperFunction.RealFunction(realFunctionOfOneVariable);
        this.changeNumberOfFunctions(1);
    }

    public void setFunction(RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable) {
        this.wf = new WraperFunction.RealFunctionSet(realVectorValuedFunctionOfOneVariable);
        this.changeNumberOfFunctions(realVectorValuedFunctionOfOneVariable.getDimensionOfTargetSpace());
    }

    public void startAt(double d) {
        this.startX = d;
        for (int i = 0; i < this.I.length; ++i) {
            this.I[i] = 0.0;
        }
    }

    public void integrateTo(double d) {
        if (this.wf == null) {
            throw new RuntimeException("no function to integrate");
        }
        this.odeSolver.setNumOfEquations(this.numberOfFunctions);
        this.odeSolver.odex(this.wf, this.I, this.startX, d);
        this.startX = d;
    }

    public void getIntegral(double[] dArray, int n) {
        int n2 = 0;
        int n3 = n;
        while (n2 < this.I.length) {
            dArray[n3] = this.I[n2];
            ++n2;
            ++n3;
        }
    }

    public void integrate(double d, double d2, double[] dArray) {
        this.integrate(d, d2, dArray, 0);
    }

    public void integrate(double d, double d2, double[] dArray, int n) {
        this.startAt(d);
        this.integrateTo(d2);
        this.getIntegral(dArray, n);
    }

    public double integrate(double d, double d2) {
        this.startAt(d);
        this.integrateTo(d2);
        return this.I[0];
    }

    static abstract class WraperFunction
    implements ODE,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;

        WraperFunction() {
        }

        static class RealFunctionSet
        extends WraperFunction {
            final RealVectorValuedFunctionOfOneVariable realFunctionSetOfOneVariable;

            RealFunctionSet(RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable) {
                this.realFunctionSetOfOneVariable = realVectorValuedFunctionOfOneVariable;
            }

            public int getNumberOfEquations() {
                return this.realFunctionSetOfOneVariable.getDimensionOfTargetSpace();
            }

            public void eval(double d, double[] dArray, double[] dArray2) {
                this.realFunctionSetOfOneVariable.eval(d, dArray2);
            }
        }

        static class RealFunction
        extends WraperFunction {
            final RealFunctionOfOneVariable realFunctionOfOneVariable;

            RealFunction(RealFunctionOfOneVariable realFunctionOfOneVariable) {
                this.realFunctionOfOneVariable = realFunctionOfOneVariable;
            }

            public int getNumberOfEquations() {
                return 1;
            }

            public void eval(double d, double[] dArray, double[] dArray2) {
                dArray2[0] = this.realFunctionOfOneVariable.eval(d);
            }
        }
    }
}

