/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.filterxml;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FramedFeature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.filterxml.XMLAnnotationTypeWriter;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.xml.XMLWriter;

public class XMLFilterWriter {
    public static final String XML_FILTER_NS = "http://www.biojava.org/FeatureFilter";
    private static final Class[] NO_ARGS = new Class[0];
    private static final Object[] NO_ARGS_VAL = new Object[0];
    private Map filterWritersByClass = new HashMap();
    private boolean strict = false;

    public XMLFilterWriter() {
        try {
            this.filterWritersByClass.put(FeatureFilter.all, new BlankFilterWriter(XML_FILTER_NS, "all"));
            this.filterWritersByClass.put(FeatureFilter.none, new BlankFilterWriter(XML_FILTER_NS, "none"));
            this.filterWritersByClass.put(FeatureFilter.ByType.class, new StringFilterWriter(XML_FILTER_NS, "byType", FeatureFilter.ByType.class.getMethod("getType", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.BySource.class, new StringFilterWriter(XML_FILTER_NS, "bySource", FeatureFilter.BySource.class.getMethod("getSource", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.ByClass.class, new ByClassFilterWriter());
            this.filterWritersByClass.put(FeatureFilter.ContainedByLocation.class, new LocationFilterWriter(XML_FILTER_NS, "containedByLocation", FeatureFilter.ContainedByLocation.class.getMethod("getLocation", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.OverlapsLocation.class, new LocationFilterWriter(XML_FILTER_NS, "overlapsLocation", FeatureFilter.OverlapsLocation.class.getMethod("getLocation", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.ShadowContainedByLocation.class, new LocationFilterWriter(XML_FILTER_NS, "shadowContainedByLocation", FeatureFilter.ContainedByLocation.class.getMethod("getLocation", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.ShadowOverlapsLocation.class, new LocationFilterWriter(XML_FILTER_NS, "shadowOverlapsLocation", FeatureFilter.OverlapsLocation.class.getMethod("getLocation", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.Not.class, new FilterFilterWriter(XML_FILTER_NS, "not", FeatureFilter.Not.class.getMethod("getChild", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.And.class, new AndFilterWriter());
            this.filterWritersByClass.put(FeatureFilter.Or.class, new OrFilterWriter());
            this.filterWritersByClass.put(FeatureFilter.StrandFilter.class, new StrandFilterWriter());
            this.filterWritersByClass.put(FeatureFilter.FrameFilter.class, new FrameFilterWriter());
            this.filterWritersByClass.put(FeatureFilter.ByParent.class, new FilterFilterWriter(XML_FILTER_NS, "byParent", FeatureFilter.ByParent.class.getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.ByAncestor.class, new FilterFilterWriter(XML_FILTER_NS, "byAncestor", FeatureFilter.ByAncestor.class.getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.ByChild.class, new FilterFilterWriter(XML_FILTER_NS, "byChild", FeatureFilter.ByChild.class.getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.ByDescendant.class, new FilterFilterWriter(XML_FILTER_NS, "byDescendant", FeatureFilter.ByDescendant.class.getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.OnlyChildren.class, new FilterFilterWriter(XML_FILTER_NS, "onlyChildren", FeatureFilter.OnlyChildren.class.getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.OnlyDescendants.class, new FilterFilterWriter(XML_FILTER_NS, "onlyDescendants", FeatureFilter.OnlyDescendants.class.getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.ByComponentName.class, new StringFilterWriter(XML_FILTER_NS, "byComponentName", FeatureFilter.ByComponentName.class.getMethod("getComponentName", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.BySequenceName.class, new StringFilterWriter(XML_FILTER_NS, "bySequenceName", FeatureFilter.BySequenceName.class.getMethod("getSequenceName", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.top_level, new BlankFilterWriter(XML_FILTER_NS, "isTopLevel"));
            this.filterWritersByClass.put(FeatureFilter.leaf, new BlankFilterWriter(XML_FILTER_NS, "isLeaf"));
            AnnotationTypeFilterWriter atfw = new AnnotationTypeFilterWriter(new XMLAnnotationTypeWriter());
            this.filterWritersByClass.put(FeatureFilter.ByAnnotationType.class, atfw);
            this.filterWritersByClass.put(FeatureFilter.ByAnnotation.class, atfw);
            this.filterWritersByClass.put(FeatureFilter.HasAnnotation.class, atfw);
            this.filterWritersByClass.put(FeatureFilter.AnnotationContains.class, atfw);
            this.filterWritersByClass.put(FeatureFilter.ByPairwiseScore.class, new ByPairwiseScoreFilterWriter());
        }
        catch (Exception ex) {
            throw new BioError("Assertion failed: couldn't initialize XMLFilterWriters", ex);
        }
    }

    public void addXMLFilterWriter(Class clazz, FilterWriter xfw) {
        this.filterWritersByClass.put(clazz, xfw);
    }

    public void addXMLFilterWriter(FeatureFilter ff, FilterWriter xfw) {
        this.filterWritersByClass.put(ff, xfw);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setIsStrict(boolean b) {
        this.strict = b;
    }

    public void writeFilter(FeatureFilter ff, XMLWriter xw) throws IllegalArgumentException, IOException {
        FilterWriter xfw = (FilterWriter)this.filterWritersByClass.get(ff);
        if (xfw == null) {
            xfw = (FilterWriter)this.filterWritersByClass.get(ff.getClass());
        }
        if (xfw != null) {
            try {
                xfw.writeFilter(ff, xw, this);
            }
            catch (ClassCastException ex) {
                throw new BioError("Filter type mismatch", ex);
            }
        } else {
            if (this.strict) {
                throw new IllegalArgumentException("Couldn't find a writer for filter of type " + ff.getClass().getName());
            }
            this.writeFilter(FeatureFilter.all, xw);
        }
    }

    private static class AnnotationTypeFilterWriter
    extends PropertyFilterWriter {
        private XMLAnnotationTypeWriter xatw;

        AnnotationTypeFilterWriter(XMLAnnotationTypeWriter xatw) throws NoSuchMethodException {
            super(XMLFilterWriter.XML_FILTER_NS, "byAnnotationType", FeatureFilter.ByAnnotationType.class.getMethod("getType", NO_ARGS));
            this.xatw = xatw;
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            this.xatw.writeAnnotationType((AnnotationType)obj, xw);
        }
    }

    private static class FrameFilterWriter
    extends PropertyFilterWriter {
        FrameFilterWriter() throws NoSuchMethodException {
            super(XMLFilterWriter.XML_FILTER_NS, "byFrame", FeatureFilter.FrameFilter.class.getMethod("getFrame", NO_ARGS));
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.print("" + ((FramedFeature.ReadingFrame)obj).getFrame());
        }
    }

    private static class StrandFilterWriter
    extends PropertyFilterWriter {
        StrandFilterWriter() throws NoSuchMethodException {
            super(XMLFilterWriter.XML_FILTER_NS, "byStrand", FeatureFilter.StrandFilter.class.getMethod("getStrand", NO_ARGS));
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.print(((StrandedFeature.Strand)obj).toString());
        }
    }

    private static class ByClassFilterWriter
    extends PropertyFilterWriter {
        ByClassFilterWriter() throws NoSuchMethodException {
            super(XMLFilterWriter.XML_FILTER_NS, "byClass", FeatureFilter.ByClass.class.getMethod("getTestClass", NO_ARGS));
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.print(((Class)obj).getName());
        }
    }

    private static class ByPairwiseScoreFilterWriter
    implements FilterWriter {
        private ByPairwiseScoreFilterWriter() {
        }

        public void writeFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            FeatureFilter.ByPairwiseScore scoreFilter = (FeatureFilter.ByPairwiseScore)ff;
            xw.openTag(XMLFilterWriter.XML_FILTER_NS, "byPairwiseScore");
            xw.openTag(XMLFilterWriter.XML_FILTER_NS, "minScore");
            xw.print("" + scoreFilter.getMinScore());
            xw.closeTag(XMLFilterWriter.XML_FILTER_NS, "minScore");
            xw.openTag(XMLFilterWriter.XML_FILTER_NS, "maxScore");
            xw.print("" + scoreFilter.getMaxScore());
            xw.closeTag(XMLFilterWriter.XML_FILTER_NS, "maxScore");
            xw.closeTag(XMLFilterWriter.XML_FILTER_NS, "byPairwiseScore");
        }
    }

    private static class OrFilterWriter
    implements FilterWriter {
        private OrFilterWriter() {
        }

        public void writeFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.openTag(XMLFilterWriter.XML_FILTER_NS, "or");
            this.writeSubFilter(ff, xw, config);
            xw.closeTag(XMLFilterWriter.XML_FILTER_NS, "or");
        }

        private void writeSubFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            if (ff instanceof FeatureFilter.Or) {
                FeatureFilter.Or ffa = (FeatureFilter.Or)ff;
                this.writeSubFilter(ffa.getChild1(), xw, config);
                this.writeSubFilter(ffa.getChild2(), xw, config);
            } else {
                config.writeFilter(ff, xw);
            }
        }
    }

    private static class AndFilterWriter
    implements FilterWriter {
        private AndFilterWriter() {
        }

        public void writeFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.openTag(XMLFilterWriter.XML_FILTER_NS, "and");
            this.writeSubFilter(ff, xw, config);
            xw.closeTag(XMLFilterWriter.XML_FILTER_NS, "and");
        }

        private void writeSubFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            if (ff instanceof FeatureFilter.And) {
                FeatureFilter.And ffa = (FeatureFilter.And)ff;
                this.writeSubFilter(ffa.getChild1(), xw, config);
                this.writeSubFilter(ffa.getChild2(), xw, config);
            } else {
                config.writeFilter(ff, xw);
            }
        }
    }

    private static class FilterFilterWriter
    extends PropertyFilterWriter {
        FilterFilterWriter(String nsURI, String localName, Method propMethod) {
            super(nsURI, localName, propMethod);
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            FeatureFilter ff = (FeatureFilter)obj;
            config.writeFilter(ff, xw);
        }
    }

    private static class LocationFilterWriter
    extends PropertyFilterWriter {
        LocationFilterWriter(String nsURI, String localName, Method propMethod) {
            super(nsURI, localName, propMethod);
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            Location l = (Location)obj;
            Iterator i = l.blockIterator();
            while (i.hasNext()) {
                Location block = (Location)i.next();
                xw.openTag("span");
                xw.attribute("start", "" + block.getMin());
                xw.attribute("stop", "" + block.getMax());
                xw.closeTag("span");
            }
        }
    }

    private static class StringFilterWriter
    extends PropertyFilterWriter {
        StringFilterWriter(String nsURI, String localName, Method propMethod) {
            super(nsURI, localName, propMethod);
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.print(obj.toString());
        }
    }

    private static abstract class PropertyFilterWriter
    implements FilterWriter {
        private final String nsURI;
        private final String localName;
        private final Method propMethod;

        PropertyFilterWriter(String nsURI, String localName, Method propMethod) {
            this.nsURI = nsURI;
            this.localName = localName;
            this.propMethod = propMethod;
        }

        public void writeFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            try {
                Object obj = this.propMethod.invoke((Object)ff, NO_ARGS_VAL);
                xw.openTag(this.nsURI, this.localName);
                this.writeContent(obj, xw, config);
                xw.closeTag(this.nsURI, this.localName);
            }
            catch (IllegalAccessException ex) {
                throw new BioError("Can't access property method", ex);
            }
            catch (InvocationTargetException ex) {
                throw new BioError("Couldn't access property", ex);
            }
        }

        protected abstract void writeContent(Object var1, XMLWriter var2, XMLFilterWriter var3) throws ClassCastException, IllegalArgumentException, IOException;
    }

    private static class BlankFilterWriter
    implements FilterWriter {
        private String nsURI;
        private String localName;

        BlankFilterWriter(String nsURI, String localName) {
            this.nsURI = nsURI;
            this.localName = localName;
        }

        public void writeFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.openTag(this.nsURI, this.localName);
            xw.closeTag(this.nsURI, this.localName);
        }
    }

    public static interface FilterWriter {
        public void writeFilter(FeatureFilter var1, XMLWriter var2, XMLFilterWriter var3) throws ClassCastException, IllegalArgumentException, IOException;
    }
}

