/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game12;

import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game12.StAXFeatureHandler;
import org.biojava.bio.seq.io.game12.StAXHandlerFactory;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.stax.IntElementHandlerBase;
import org.biojava.utils.stax.StAXContentHandler;

public class GAMESpanHandler
extends StAXFeatureHandler {
    int start;
    int end;
    boolean gotStart = false;
    boolean gotEnd = false;
    Location loc;
    StrandedFeature.Strand strand;
    public static final StAXHandlerFactory GAME_SPAN_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMESpanHandler(staxenv);
        }
    };

    GAMESpanHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        super.addHandler(new ElementRecognizer.ByLocalName("start"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StartHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("end"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new EndHandler();
            }
        });
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) {
        if (!this.gotStart || !this.gotEnd) {
            return;
        }
        this.strand = this.start < this.end ? StrandedFeature.POSITIVE : (this.start > this.end ? StrandedFeature.NEGATIVE : StrandedFeature.UNKNOWN);
        int min = Math.min(this.start, this.end);
        int max = Math.max(this.start, this.end);
        this.loc = Math.abs(this.start - this.end) == 1 ? new PointLocation(min) : new RangeLocation(min, max);
    }

    private class EndHandler
    extends IntElementHandlerBase {
        private EndHandler() {
        }

        protected void setIntValue(int endVal) {
            GAMESpanHandler.this.end = endVal;
            GAMESpanHandler.this.gotEnd = true;
        }
    }

    private class StartHandler
    extends IntElementHandlerBase {
        private StartHandler() {
        }

        protected void setIntValue(int startVal) {
            GAMESpanHandler.this.start = startVal;
            GAMESpanHandler.this.gotStart = true;
        }
    }
}

