/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.AminoAcidImpl;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomIterator;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureImpl;
import org.biojava.bio.structure.io.PDBParseException;

public class Mutator {
    List<String> supportedAtoms = new ArrayList<String>();

    public Mutator() {
        this.supportedAtoms.add("N");
        this.supportedAtoms.add("CA");
        this.supportedAtoms.add("C");
        this.supportedAtoms.add("O");
        this.supportedAtoms.add("CB");
    }

    public Structure mutate(Structure struc, String chainId, String pdbResnum, String newType) throws PDBParseException {
        StructureImpl newstruc = new StructureImpl();
        List<Chain> chains = struc.getChains(0);
        for (Chain c : chains) {
            if (c.getName().equals(chainId)) {
                ChainImpl newchain = new ChainImpl();
                newchain.setName(c.getName());
                List<Group> groups = c.getGroups();
                for (Group g : groups) {
                    String rnum = g.getPDBCode();
                    if (rnum.equals(pdbResnum) && g.getType().equals("amino")) {
                        AminoAcid newgroup = this.mutateResidue((AminoAcid)g, newType);
                        newchain.addGroup(newgroup);
                        continue;
                    }
                    newchain.addGroup(g);
                }
                newstruc.addChain(newchain);
                continue;
            }
            newstruc.addChain(c);
        }
        return newstruc;
    }

    public AminoAcid mutateResidue(AminoAcid oldAmino, String newType) throws PDBParseException {
        AminoAcidImpl newgroup = new AminoAcidImpl();
        newgroup.setPDBCode(oldAmino.getPDBCode());
        newgroup.setPDBName(newType);
        AtomIterator aiter = new AtomIterator(oldAmino);
        while (aiter.hasNext()) {
            Atom a = aiter.next();
            if (!this.supportedAtoms.contains(a.getName())) continue;
            newgroup.addAtom(a);
        }
        return newgroup;
    }
}

