/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences.annotation;

import de.jstacs.NonParsableException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocatedSequenceAnnotation
extends SequenceAnnotation {
    private int position;

    public LocatedSequenceAnnotation(int position, String type, String identifier, Result ... results) {
        super(type, identifier, (Result[][])new Result[][]{results});
        this.position = position;
    }

    public LocatedSequenceAnnotation(int position, String type, String identifier, Collection<Result> results) {
        super(type, identifier, results);
        this.position = position;
    }

    public LocatedSequenceAnnotation(int position, String type, String identifier, SequenceAnnotation[] annotations, Result ... additionalAnnotation) {
        super(type, identifier, annotations, additionalAnnotation);
        this.position = position;
    }

    public LocatedSequenceAnnotation(String type, String identifier, LocatedSequenceAnnotation[] annotations, Result ... additionalAnnotation) {
        super(type, identifier, annotations, additionalAnnotation);
        this.position = Integer.MAX_VALUE;
        for (int i = 0; i < annotations.length; ++i) {
            if (annotations[i].getPosition() >= this.position) continue;
            this.position = annotations[i].getPosition();
        }
    }

    public LocatedSequenceAnnotation(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "locatedSequenceAnnotation");
        super.fromXML(XMLParser.extractForTag(representation, "annotation"));
        this.position = XMLParser.extractIntForTag(representation, "position");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "annotation");
        XMLParser.appendIntWithTags(buf, this.position, "position");
        XMLParser.addTags(buf, "locatedSequenceAnnotation");
        return buf;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append("position: ");
        buf.append(this.position);
        buf.append("\n");
        return buf.toString();
    }
}

