/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class FileManager {
    private static byte[] buffer = new byte[100000];

    private FileManager() {
    }

    public static int copyDiff(File source, File target, Date date, boolean recursive, FileFilter filter) throws IllegalArgumentException, IOException {
        if (!source.isDirectory() || !target.isDirectory()) {
            throw new IllegalArgumentException("The source and the target have to be directories.");
        }
        File[] files = source.listFiles(filter);
        int anz = 0;
        long time = date.getTime();
        for (File f : files) {
            if (f.isDirectory()) {
                int i;
                if (!recursive) continue;
                File help = new File(target.getAbsolutePath() + "/" + f.getName());
                boolean existsBefore = help.exists();
                if (!existsBefore) {
                    help.mkdir();
                }
                if ((i = FileManager.copyDiff(f, help, date, recursive, filter)) == 0) {
                    if (existsBefore) continue;
                    help.delete();
                    continue;
                }
                anz += i;
                continue;
            }
            if (f.lastModified() < time) continue;
            FileManager.copy(f.getAbsolutePath(), target.getAbsolutePath() + "/" + f.getName());
            ++anz;
        }
        return anz;
    }

    public static void copy(String from, String to) throws IOException {
        FileManager.copy(from, to, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void copy(String from, String to, byte[] buffer) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int amountRead;
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            while ((amountRead = in.read(buffer)) > -1) {
                out.write(buffer, 0, amountRead);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static StringBuffer readFile(File file) throws IOException {
        String help;
        BufferedReader r = new BufferedReader(new FileReader(file), 100000);
        StringBuffer res = new StringBuffer(1000000);
        while ((help = r.readLine()) != null) {
            res.append(help + "\n");
        }
        r.close();
        return res;
    }

    public static void writeFile(File outputFile, StringBuffer buffer) throws IOException {
        BufferedWriter b = new BufferedWriter(new FileWriter(outputFile));
        b.write(buffer.toString());
        b.close();
    }
}

