/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import de.jstacs.io.AbstractStringExtractor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class SparseStringExtractor
extends AbstractStringExtractor {
    private BufferedReader reader;
    private String current;
    private String next;
    private StringBuffer help;

    public SparseStringExtractor(File file) throws IOException, FileNotFoundException {
        this(file, '#');
    }

    public SparseStringExtractor(File file, char ignore) throws IOException, FileNotFoundException {
        this(file, ignore, file.getName());
    }

    public SparseStringExtractor(File file, String annotation) throws IOException, FileNotFoundException {
        this(file, '#', annotation);
    }

    public SparseStringExtractor(File file, char ignore, String annotation) throws IOException, FileNotFoundException {
        super(ignore);
        this.reader = new BufferedReader(new FileReader(file));
        this.help = new StringBuffer();
        this.next = this.getNext();
        this.annotation = annotation;
    }

    public boolean hasMoreElements() {
        return this.next != null;
    }

    public String nextElement() {
        this.current = this.next;
        this.next = this.getNext();
        return this.current;
    }

    private String getNext() {
        String res = null;
        try {
            String line;
            while ((line = this.reader.readLine()) != null && this.ignorePattern.matcher(line).matches()) {
            }
            if (line == null || this.ignore != '>') {
                res = line;
            } else {
                while (line != null && !this.ignorePattern.matcher(line).matches()) {
                    this.help.append(line);
                    line = this.reader.readLine();
                }
                res = this.help.toString();
                this.help.delete(0, this.help.length());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Forwarding IOException: " + e.getMessage());
        }
        return res;
    }

    protected void finalize() throws Throwable {
        this.reader.close();
        super.finalize();
    }
}

