/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.homogeneous;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.WrongAlphabetException;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.io.XMLParser;
import de.jstacs.models.discrete.DGMParameterSet;
import de.jstacs.models.discrete.homogeneous.HomogeneousModel;
import de.jstacs.models.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.util.Random;

public class HomogeneousMM
extends HomogeneousModel {
    private HomogeneousModel.HomCondProb[] condProb;
    private static final String XML_TAG = "HomogeneousMarkovModel";

    public HomogeneousMM(HomMMParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
    }

    public HomogeneousMM(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
    }

    public HomogeneousMM clone() throws CloneNotSupportedException {
        HomogeneousMM clone = (HomogeneousMM)super.clone();
        clone.condProb = clone.cloneHomProb(this.condProb);
        return clone;
    }

    protected Sequence getRandomSequence(Random r, int length) throws WrongAlphabetException, WrongSequenceTypeException {
        int[] seq = new int[length];
        int j = 0;
        int val = 0;
        for (j = 0; j < this.order && j < length; ++j) {
            seq[j] = this.chooseFromDistr(this.condProb[j], val, val + this.powers[1] - 1, r.nextDouble());
            val = (val + seq[j]) * this.powers[1];
        }
        while (j < length) {
            seq[j] = this.chooseFromDistr(this.condProb[this.order], val, val + this.powers[1] - 1, r.nextDouble());
            val = (val + seq[j++]) % this.powers[this.order] * this.powers[1];
        }
        return new IntSequence(this.alphabets, seq);
    }

    public String getInstanceName() {
        return "hMM(" + this.getMaximalMarkovOrder() + ") " + (this.getESS() == 0.0 ? "ML" : "MAP");
    }

    public double getLogPriorTerm() throws Exception {
        if (!this.trained) {
            throw new NotTrainedException();
        }
        double p = 0.0;
        double ess = this.getESS();
        if (ess != 0.0) {
            for (int counter1 = 0; counter1 < this.condProb.length; ++counter1) {
                int anz1 = this.condProb[counter1].getNumberOfSpecificConstraints();
                double pot = ess / (double)anz1;
                p += (double)anz1 * (Gamma.logOfGamma((double)((double)this.powers[1] * pot)) / (double)this.powers[1] - Gamma.logOfGamma((double)pot));
                for (int counter2 = 0; counter2 < anz1; ++counter2) {
                    p += pot * this.condProb[counter1].getLnFreq(counter2);
                }
            }
        }
        return p;
    }

    protected double logProbFor(Sequence sequence, int startpos, int endpos) {
        if (endpos < startpos) {
            return 0.0;
        }
        int idx = sequence.discreteVal(startpos++);
        double erg = this.condProb[0].getLnFreq(idx);
        for (int i = 1; i < this.order && startpos <= endpos; ++i) {
            idx = idx * this.powers[1] + sequence.discreteVal(startpos++);
            erg += this.condProb[i].getLnFreq(idx);
        }
        while (startpos <= endpos) {
            idx = idx % this.powers[this.order] * this.powers[1] + sequence.discreteVal(startpos++);
            erg += this.condProb[this.order].getLnFreq(idx);
        }
        return erg;
    }

    protected double probFor(Sequence sequence, int startpos, int endpos) {
        if (endpos < startpos) {
            return 0.0;
        }
        int idx = sequence.discreteVal(startpos++);
        double erg = this.condProb[0].getFreq(idx);
        for (int i = 1; i < this.order && startpos <= endpos; ++i) {
            idx = idx * this.powers[1] + sequence.discreteVal(startpos++);
            erg *= this.condProb[i].getFreq(idx);
        }
        while (startpos <= endpos) {
            idx = idx % this.powers[this.order] * this.powers[1] + sequence.discreteVal(startpos++);
            erg *= this.condProb[this.order].getFreq(idx);
        }
        return erg;
    }

    public String toString() {
        String erg = "description: " + this.getDescription();
        if (this.trained && this.getMaximalMarkovOrder() == 0) {
            erg = erg + "\n";
            for (int i = 0; i < this.condProb[0].getNumberOfSpecificConstraints(); ++i) {
                erg = erg + "\t" + this.alphabets.getSymbol(this.condProb[0].getPosition(0), i) + ": " + this.condProb[0].getFreq(i);
            }
        }
        return erg;
    }

    public void train(Sample data, double[] weights) throws Exception {
        this.train(new Sample[]{data}, new double[][]{weights});
    }

    public void train(Sample[] data, double[][] weights) throws Exception {
        if (data.length != weights.length) {
            throw new IllegalArgumentException("The constraint data.length == weights.length is not fulfilled.");
        }
        int i = 0;
        while (i < this.condProb.length) {
            this.condProb[i++].reset();
        }
        for (i = 0; i < data.length; ++i) {
            if (data[i] == null) continue;
            this.countHomogeneous(data[i], weights[i]);
        }
        this.estimate();
    }

    protected StringBuffer getFurtherModelInfos() {
        if (this.condProb != null) {
            StringBuffer xml = new StringBuffer(1000);
            int l = this.condProb.length;
            StringBuffer source = new StringBuffer(25 + l * 500);
            XMLParser.appendIntWithTags(source, l, "length");
            for (int j = 0; j < l; ++j) {
                XMLParser.appendStringWithTags(source, this.condProb[j].toXML().toString(), "pos val=\"" + j + "\"", "pos");
            }
            XMLParser.addTags(source, "condProb");
            xml.append(source);
            return xml;
        }
        return null;
    }

    protected String getXMLTag() {
        return XML_TAG;
    }

    protected void set(DGMParameterSet params, boolean trained) throws CloneNotSupportedException, NonParsableException {
        super.set(params, trained);
        if (!trained) {
            this.condProb = new HomogeneousModel.HomCondProb[this.order + 1];
            for (int i = 0; i < this.condProb.length; i = (int)((byte)(i + 1))) {
                int[] pos = new int[i + 1];
                for (int j = 0; j <= i; j = (int)((byte)(j + 1))) {
                    pos[j] = j;
                }
                int k = this.powers[i] * this.powers[1];
                this.condProb[i] = new HomogeneousModel.HomCondProb(this, pos, k);
            }
        }
    }

    protected void setFurtherModelInfos(StringBuffer xml) throws NonParsableException {
        if (this.trained) {
            StringBuffer help = XMLParser.extractForTag(xml, "condProb");
            this.condProb = new HomogeneousModel.HomCondProb[XMLParser.extractIntForTag(help, "length")];
            for (int j = 0; j < this.condProb.length; ++j) {
                this.condProb[j] = new HomogeneousModel.HomCondProb((HomogeneousModel)this, XMLParser.extractForTag(help, "pos val=\"" + j + "\"", "pos"));
            }
        }
    }

    private void countHomogeneous(Sample data, double[] weights) throws WrongAlphabetException {
        int d = data.getNumberOfElements();
        if (weights != null && d != weights.length) {
            throw new IllegalArgumentException("The weights are not suitable for the data (wrong dimension).");
        }
        if (!this.alphabets.checkConsistency(data.getAlphabetContainer())) {
            throw new WrongAlphabetException("The alphabets of the model and the Sample are not suitable.");
        }
        Sample.ElementEnumerator ei = new Sample.ElementEnumerator(data);
        double w = 1.0;
        for (int counter1 = 0; counter1 < d; ++counter1) {
            int lengthCounter;
            Sequence seq = ei.nextElement();
            int l = seq.getLength();
            int idx = 0;
            if (weights != null) {
                w = weights[counter1];
            }
            for (lengthCounter = 0; lengthCounter < this.order && lengthCounter < l; ++lengthCounter) {
                idx = idx * this.powers[1] + seq.discreteVal(lengthCounter);
                this.condProb[lengthCounter].add(idx, w);
            }
            while (lengthCounter < l) {
                idx = idx % this.powers[this.order] * this.powers[1] + seq.discreteVal(lengthCounter++);
                this.condProb[this.order].add(idx, w);
            }
        }
    }

    private void estimate() {
        double ess = this.getESS();
        for (int i = 0; i < this.condProb.length; ++i) {
            this.condProb[i].estimate(ess);
        }
        this.trained = true;
    }
}

