/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.RangeIterator;
import de.jstacs.parameters.Rangeable;
import de.jstacs.parameters.SimpleParameter;

public class ParameterSetContainer
extends Parameter
implements Rangeable,
RangeIterator {
    private String name;
    private String comment;
    private ParameterSet parameters;
    protected String errorMessage;

    public ParameterSetContainer(String name, String comment, ParameterSet content) {
        this.name = name;
        this.comment = comment;
        this.parameters = content;
        this.parameters.setParent(this);
        this.errorMessage = null;
    }

    public ParameterSetContainer(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    public ParameterSetContainer clone() throws CloneNotSupportedException {
        ParameterSetContainer clone = (ParameterSetContainer)super.clone();
        ParameterSet parameterSet = clone.parameters = this.parameters == null ? null : this.parameters.clone();
        if (clone.parameters != null) {
            clone.parameters.setParent(clone);
        }
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDatatype() {
        return DataType.PARAMETERSET;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isRequired() {
        return true;
    }

    public boolean checkValue(Object value) {
        return value == null || value instanceof ParameterSet;
    }

    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        if (!this.checkValue(value)) {
            throw new SimpleParameter.IllegalValueException("Only parameter sets allowed for ParameterSetContainer!");
        }
        this.parameters = (ParameterSet)value;
        this.parameters.setParent(this);
    }

    public ParameterSet getValue() {
        return this.parameters;
    }

    public boolean hasDefaultOrIsSet() {
        return this.parameters != null && this.parameters.hasDefaultOrIsSet();
    }

    public boolean isSet() {
        return this.parameters != null;
    }

    public boolean isAtomic() {
        return false;
    }

    public String getErrorMessage() {
        return this.parameters.getErrorMessage();
    }

    public void simplify() {
        this.parameters.simplify();
    }

    public void reset() {
        this.parameters.reset();
    }

    public void setDefault(Object defaultValue) throws Exception {
        throw new Exception("Not applicable to ParameterSetContainer");
    }

    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameter");
        XMLParser.appendStringWithTags(buf, this.name, "name");
        XMLParser.appendStringWithTags(buf, this.comment, "comment");
        XMLParser.appendStringWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendStorableOrNullWithTags(buf, this.parameters, "parameters");
        XMLParser.addTags(buf, "parameterSetContainer");
        return buf;
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "parameterSetContainer");
        super.fromXML(XMLParser.extractForTag(representation, "superParameter"));
        this.name = XMLParser.extractStringForTag(representation, "name");
        this.comment = XMLParser.extractStringForTag(representation, "comment");
        this.errorMessage = XMLParser.extractStringForTag(representation, "errorMessage");
        if (this.errorMessage != null && this.errorMessage.equals("null")) {
            this.errorMessage = null;
        }
        this.parameters = (ParameterSet)XMLParser.extractStorableOrNullForTag(representation, "parameters");
        this.parameters.setParent(this);
    }

    public boolean isRangeable() {
        return true;
    }

    public Parameter getRangedInstance() throws Exception {
        this.parameters.makeRanged();
        return this;
    }

    public boolean next() throws ParameterException {
        return this.parameters.next();
    }

    public void resetToFirst() {
        this.parameters.resetToFirst();
    }

    public boolean isRanged() {
        return this.parameters.isRanged();
    }

    public int getNumberOfValues() {
        return this.parameters.getNumberOfValues();
    }

    public String valuesToString() {
        return "(" + this.parameters.valuesToString() + ")";
    }
}

